/*
 * Decompiled with CFR 0.152.
 */
package org.snt.inmemantlr.tree;

import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snt.inmemantlr.exceptions.ParseTreeProcessorException;
import org.snt.inmemantlr.tree.ParseTree;
import org.snt.inmemantlr.tree.ParseTreeNode;
import org.snt.inmemantlr.tree.ParseTreeProcessor;

public class XmlProcessor
extends ParseTreeProcessor<StringBuilder, StringBuilder> {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlProcessor.class);
    private boolean idxOnly = false;

    public XmlProcessor(ParseTree parseTree, boolean idxOnly) {
        super(parseTree);
        this.idxOnly = idxOnly;
    }

    public XmlProcessor(ParseTree parseTree) {
        this(parseTree, true);
    }

    @Override
    public StringBuilder getResult() {
        StringBuilder root = (StringBuilder)this.smap.get(this.parseTree.getRoot());
        root.insert(0, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        return root;
    }

    @Override
    protected void initialize() {
    }

    @Override
    protected void process(ParseTreeNode n) throws ParseTreeProcessorException {
        StringBuilder sb = new StringBuilder();
        if (!n.hasParent()) {
            this.simpleProp(n);
            return;
        }
        sb.append("<nt>");
        sb.append("<name>");
        sb.append(n.getRule());
        sb.append("</name>");
        sb.append("<ran>");
        sb.append(n.getSidx());
        sb.append(",");
        sb.append(n.getEidx());
        sb.append("</ran>");
        if (!this.idxOnly) {
            sb.append("<lbl>");
            sb.append(StringEscapeUtils.unescapeXml((String)n.getLabel()));
            sb.append("</lbl>");
        }
        if (n.hasChildren()) {
            sb.append("<cld>");
            for (int i = 0; i < n.getChildren().size(); ++i) {
                sb.append((CharSequence)this.smap.get(n.getChild(i)));
            }
            sb.append("</cld>");
        }
        sb.append("</nt>");
        this.smap.put(n, sb);
    }
}

