/*
 * Decompiled with CFR 0.152.
 */
package org.snt.inmemantlr.utils;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class EscapeUtils {
    private static final Set<Character> SPECIAL = Stream.of(Character.valueOf('+'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('&'), Character.valueOf('^'), Character.valueOf('-'), Character.valueOf('?'), Character.valueOf('*'), Character.valueOf('\"'), Character.valueOf('$'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('.'), Character.valueOf('|'), Character.valueOf('#')).collect(Collectors.toSet());

    private EscapeUtils() {
    }

    public static String escapeSpecialCharacters(String s) {
        if (s == null) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        for (char c : s.toCharArray()) {
            if (SPECIAL.contains(Character.valueOf(c))) {
                out.append("\\").append(c);
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public static String unescapeSpecialCharacters(String s) {
        if (s == null) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        char pred = ' ';
        for (char c : s.toCharArray()) {
            if (pred == '\\' && SPECIAL.contains(Character.valueOf(c))) {
                out.deleteCharAt(out.length() - 1);
                out.append(c);
            } else {
                out.append(c);
            }
            pred = c;
        }
        return out.toString();
    }
}

