/*
 * Decompiled with CFR 0.152.
 */
package org.snt.inmemantlr.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.apache.commons.io.FileExistsException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtils.class);

    private FileUtils() {
    }

    public static String loadFileContent(File path) {
        return FileUtils.loadFileContent(path.getAbsolutePath());
    }

    public static String loadFileContent(String path) {
        byte[] bytes;
        try (RandomAccessFile f = new RandomAccessFile(path, "r");){
            bytes = new byte[(int)f.length()];
            f.read(bytes);
        }
        catch (IOException e) {
            return null;
        }
        return new String(bytes);
    }

    public static String getStringFromStream(InputStream is) {
        try {
            return IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void writeStringToFile(String string, String file) throws FileExistsException {
        block8: {
            LOGGER.debug("file {}", (Object)file);
            if (Files.exists(Paths.get(file, new String[0]), new LinkOption[0])) {
                throw new FileExistsException("File " + file + " already exists");
            }
            File f = new File(file);
            f.getParentFile().mkdirs();
            try (PrintWriter out = new PrintWriter(f);){
                out.write(string);
            }
            catch (FileNotFoundException e) {
                LOGGER.error(e.getMessage());
                if ($assertionsDisabled) break block8;
                throw new AssertionError();
            }
        }
    }
}

