/*
 * Decompiled with CFR 0.152.
 */
package org.snt.inmemantlr.utils;

import org.snt.inmemantlr.exceptions.InjectionException;
import org.snt.inmemantlr.tree.ParseTree;
import org.snt.inmemantlr.tree.ParseTreeNode;
import org.snt.inmemantlr.utils.InjectionPointDetector;

public enum ParseTreeManipulator {
    INTANCE;


    private void expand(ParseTree orig, ParseTreeNode par, ParseTreeNode toinj) {
        ParseTreeNode nn = orig.newNode(par, toinj.getRule(), toinj.getLabel(), toinj.getSidx(), toinj.getEidx(), toinj.getLine(), toinj.getCharPositionInLine());
        for (ParseTreeNode c : toinj.getChildren()) {
            this.expand(orig, nn, c);
        }
        par.addChild(nn);
    }

    public void inject(ParseTree rcv, InjectionPointDetector injectionPoint, ParseTree toinject) throws InjectionException {
        ParseTreeNode ip = injectionPoint.detect(rcv);
        if (!ip.hasParent()) {
            throw new InjectionException("injection point without parent");
        }
        ParseTreeNode par = ip.getParent();
        ParseTreeNode nn = rcv.newNode(par, toinject.getRoot().getFirstChild().getRule(), toinject.getRoot().getFirstChild().getLabel(), toinject.getRoot().getFirstChild().getSidx(), toinject.getRoot().getFirstChild().getEidx(), toinject.getRoot().getFirstChild().getLine(), toinject.getRoot().getFirstChild().getCharPositionInLine());
        int pos = par.getChildren().indexOf(ip);
        switch (injectionPoint.getPosition()) {
            case BEFORE: {
                par.getChildren().add(pos, nn);
                break;
            }
            case AFTER: {
                par.getChildren().add(pos + 1, nn);
            }
        }
        for (ParseTreeNode cc : toinject.getRoot().getFirstChild().getChildren()) {
            this.expand(rcv, nn, cc);
        }
    }
}

