/*
 * Decompiled with CFR 0.152.
 */
package pdi.jwt;

import io.circe.Decoder$;
import io.circe.Encoder$;
import io.circe.HCursor;
import io.circe.Json;
import io.circe.syntax.package;
import io.circe.syntax.package$;
import java.io.Serializable;
import pdi.jwt.JwtAlgorithm;
import pdi.jwt.JwtAlgorithm$;
import pdi.jwt.JwtJsonCommon;
import scala.Function1;
import scala.Option;
import scala.Predef$;

public interface JwtCirceParser<H, C>
extends JwtJsonCommon<Json, H, C> {
    public static Json parse$(JwtCirceParser $this, String value) {
        return $this.parse(value);
    }

    default public Json parse(String value) {
        return (Json)io.circe.jawn.package$.MODULE$.parse(value).fold((Function1 & Serializable)_$1 -> {
            throw _$1;
        }, (Function1 & Serializable)x -> (Json)Predef$.MODULE$.identity(x));
    }

    public static String stringify$(JwtCirceParser $this, Json value) {
        return $this.stringify(value);
    }

    default public String stringify(Json value) {
        Json json = (Json)package$.MODULE$.EncoderOps((Object)value);
        return package.EncoderOps$.MODULE$.asJson$extension((Object)json, Encoder$.MODULE$.encodeJson()).noSpaces();
    }

    public static Option getAlgorithm$(JwtCirceParser $this, Json header) {
        return $this.getAlgorithm(header);
    }

    default public Option<JwtAlgorithm> getAlgorithm(Json header) {
        return this.getAlg(header.hcursor());
    }

    public static Option getAlg$(JwtCirceParser $this, HCursor cursor) {
        return $this.getAlg(cursor);
    }

    default public Option<JwtAlgorithm> getAlg(HCursor cursor) {
        return cursor.get("alg", Decoder$.MODULE$.decodeString()).toOption().filterNot((Function1 & Serializable)_$2 -> {
            String string = _$2;
            String string2 = "none";
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).map((Function1 & Serializable)algo -> JwtAlgorithm$.MODULE$.fromString(algo));
    }
}

