/*
 * Decompiled with CFR 0.152.
 */
package com.github.k0kubun.builder.query.graphql.builder;

import com.github.k0kubun.builder.query.graphql.builder.QueryBuilder;
import com.github.k0kubun.builder.query.graphql.model.GraphQLField;
import com.github.k0kubun.builder.query.graphql.model.GraphQLObject;
import com.github.k0kubun.builder.query.graphql.model.StringField;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class QueryBuilderImpl
implements QueryBuilder {
    private final List<GraphQLField> fields = new ArrayList<GraphQLField>();

    @Override
    public QueryBuilderImpl field(String name) {
        this.fields.add(new StringField(name));
        return this;
    }

    @Override
    public QueryBuilderImpl object(String name, GraphQLObject object) {
        object.setName(name);
        this.fields.add(object);
        return this;
    }

    @Override
    public QueryBuilderImpl objects(String name, Integer first, GraphQLObject object) {
        object.setName(name);
        object.setParams((Map<String, Object>)ImmutableMap.of((Object)"first", (Object)first));
        this.fields.add(object);
        return this;
    }

    @Override
    public QueryBuilderImpl objects(String name, Integer first, String after, GraphQLObject object) {
        object.setName(name);
        object.setParams((Map<String, Object>)ImmutableMap.of((Object)"first", (Object)first, (Object)"after", (Object)after));
        this.fields.add(object);
        return this;
    }

    @Override
    public QueryBuilderImpl object(String name, Map<String, Object> params, GraphQLObject object) {
        object.setName(name);
        object.setParams(params);
        this.fields.add(object);
        return this;
    }

    @Override
    public String build() {
        StringBuilder builder = new StringBuilder();
        for (GraphQLField field : this.fields) {
            builder.append(field.indentRender(0));
        }
        return builder.toString();
    }
}

