/*
 * Decompiled with CFR 0.152.
 */
package com.github.k0kubun.builder.query.graphql.model;

import com.github.k0kubun.builder.query.graphql.model.GraphQLField;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

public class GraphQLObject
implements GraphQLField {
    private final List<GraphQLField> fields;
    private String name;
    private Map<String, Object> params = ImmutableMap.of();

    public GraphQLObject(List<GraphQLField> fields) {
        this.fields = fields;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public List<GraphQLField> getFields() {
        return this.fields;
    }

    @Override
    public String indentRender(int indent) {
        StringBuilder builder = new StringBuilder();
        this.printIndent(builder, indent);
        builder.append(this.name);
        if (this.params.size() > 0) {
            builder.append("(");
            boolean first = true;
            for (Map.Entry<String, Object> param : this.params.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(" ");
                }
                builder.append(param.getKey());
                builder.append(":");
                Object value = param.getValue();
                if (value instanceof String) {
                    builder.append("\"");
                    builder.append(value.toString().replace("\"", "\\\""));
                    builder.append("\"");
                    continue;
                }
                builder.append(value.toString());
            }
            builder.append(")");
        }
        builder.append(" {\n");
        for (GraphQLField field : this.fields) {
            builder.append(field.indentRender(indent + 1));
        }
        this.printIndent(builder, indent);
        builder.append("}\n");
        return builder.toString();
    }

    private void printIndent(StringBuilder builder, int indent) {
        for (int i = 0; i < indent; ++i) {
            builder.append("  ");
        }
    }
}

