/*
 * Decompiled with CFR 0.152.
 */
package com.github.k0kubun.builder.query.graphql.model;

import com.github.k0kubun.builder.query.graphql.model.GraphQLField;
import com.github.k0kubun.builder.query.graphql.model.GraphQLParam;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;

public class GraphQLObject
implements GraphQLField {
    private final List<GraphQLField> fields;
    private String name;
    private Map<String, Object> params = ImmutableMap.of();
    private GraphQLParam objectParam;

    public GraphQLObject(List<GraphQLField> fields) {
        this.fields = fields;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public void setObjectParam(GraphQLParam objectParam) {
        this.objectParam = objectParam;
    }

    public List<GraphQLField> getFields() {
        return this.fields;
    }

    @Override
    public String indentRender(int indent) {
        StringBuilder builder = new StringBuilder();
        this.printIndent(builder, indent);
        builder.append(this.name);
        if (this.objectParam != null) {
            this.renderComplexParams(builder);
        } else if (this.params.size() > 0) {
            this.renderSingleParams(builder);
        }
        builder.append(" {\n");
        for (GraphQLField field : this.fields) {
            builder.append(field.indentRender(indent + 1));
        }
        this.printIndent(builder, indent);
        builder.append("}\n");
        return builder.toString();
    }

    private void renderSingleParams(StringBuilder builder) {
        builder.append("(");
        boolean first = true;
        for (Map.Entry<String, Object> param : this.params.entrySet()) {
            if (first) {
                first = false;
            } else {
                builder.append(" ");
            }
            builder.append(param.getKey());
            builder.append(":");
            Object value = param.getValue();
            if (value instanceof String) {
                this.printString(builder, value);
                continue;
            }
            builder.append(value.toString());
        }
        builder.append(")");
    }

    private void renderComplexParams(StringBuilder builder) {
        builder.append("(");
        this.renderInternalObjectParam(builder, this.objectParam);
        builder.append(")");
    }

    private void renderObjectParam(StringBuilder builder, Object value) {
        builder.append("{");
        this.renderInternalObjectParam(builder, value);
        builder.append("}");
    }

    private void renderInternalObjectParam(StringBuilder builder, Object param) {
        Field[] fields = param.getClass().getDeclaredFields();
        boolean first = true;
        for (Field classField : fields) {
            Object value;
            if (classField.isSynthetic()) continue;
            classField.setAccessible(true);
            try {
                value = classField.get(param);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            if (value == null) continue;
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(classField.getName());
            builder.append(":");
            if (value instanceof String) {
                this.printString(builder, value);
                continue;
            }
            if (value instanceof Integer || value instanceof Long) {
                builder.append(value);
                continue;
            }
            if (value instanceof Boolean) {
                this.renderBooleanParam(builder, value);
                continue;
            }
            if (value instanceof Iterable) {
                this.renderListParam(builder, value);
                continue;
            }
            this.renderObjectParam(builder, value);
        }
    }

    private void renderBooleanParam(StringBuilder builder, Object param) {
        if (Boolean.TRUE.equals(param)) {
            builder.append("true");
        } else {
            builder.append("false");
        }
    }

    private void renderListParam(StringBuilder builder, Object param) {
        builder.append("[");
        Iterable list = (Iterable)param;
        boolean first = true;
        for (Object value : list) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            if (value instanceof String) {
                this.printString(builder, value);
                continue;
            }
            if (value instanceof Integer || value instanceof Long) {
                builder.append(value);
                continue;
            }
            if (value instanceof Boolean) {
                this.renderBooleanParam(builder, value);
                continue;
            }
            throw new UnsupportedOperationException();
        }
        builder.append("]");
    }

    private void printString(StringBuilder builder, Object value) {
        builder.append("\"");
        builder.append(value.toString().replace("\"", "\\\""));
        builder.append("\"");
    }

    private void printIndent(StringBuilder builder, int indent) {
        for (int i = 0; i < indent; ++i) {
            builder.append("  ");
        }
    }
}

