/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler;

import com.github.kagkarlsson.scheduler.Clock;
import com.github.kagkarlsson.scheduler.ExecutePicked;
import com.github.kagkarlsson.scheduler.Executor;
import com.github.kagkarlsson.scheduler.PollStrategy;
import com.github.kagkarlsson.scheduler.PollingStrategyConfig;
import com.github.kagkarlsson.scheduler.SchedulerClient;
import com.github.kagkarlsson.scheduler.SchedulerState;
import com.github.kagkarlsson.scheduler.TaskRepository;
import com.github.kagkarlsson.scheduler.TaskResolver;
import com.github.kagkarlsson.scheduler.logging.ConfigurableLogger;
import com.github.kagkarlsson.scheduler.stats.StatsRegistry;
import com.github.kagkarlsson.scheduler.task.Execution;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockAndFetchCandidates
implements PollStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(LockAndFetchCandidates.class);
    private final Executor executor;
    private final TaskRepository taskRepository;
    private final SchedulerClient schedulerClient;
    private final StatsRegistry statsRegistry;
    private final TaskResolver taskResolver;
    private final SchedulerState schedulerState;
    private final ConfigurableLogger failureLogger;
    private final Clock clock;
    private final PollingStrategyConfig pollingStrategyConfig;
    private final Runnable triggerCheckForNewExecutions;
    private final int lowerLimit;
    private final int upperLimit;
    private AtomicBoolean moreExecutionsInDatabase = new AtomicBoolean(false);

    public LockAndFetchCandidates(Executor executor, TaskRepository taskRepository, SchedulerClient schedulerClient, int threadpoolSize, StatsRegistry statsRegistry, SchedulerState schedulerState, ConfigurableLogger failureLogger, TaskResolver taskResolver, Clock clock, PollingStrategyConfig pollingStrategyConfig, Runnable triggerCheckForNewExecutions) {
        this.executor = executor;
        this.taskRepository = taskRepository;
        this.schedulerClient = schedulerClient;
        this.statsRegistry = statsRegistry;
        this.taskResolver = taskResolver;
        this.schedulerState = schedulerState;
        this.failureLogger = failureLogger;
        this.clock = clock;
        this.pollingStrategyConfig = pollingStrategyConfig;
        this.triggerCheckForNewExecutions = triggerCheckForNewExecutions;
        this.lowerLimit = pollingStrategyConfig.getLowerLimit(threadpoolSize);
        this.upperLimit = pollingStrategyConfig.getUpperLimit(threadpoolSize);
    }

    @Override
    public void run() {
        Instant now = this.clock.now();
        int executionsToFetch = this.upperLimit - this.executor.getNumberInQueueOrProcessing();
        if (executionsToFetch <= 0) {
            LOG.trace("No executions to fetch.");
            return;
        }
        List<Execution> pickedExecutions = this.taskRepository.lockAndGetDue(now, executionsToFetch);
        LOG.trace("Picked {} taskinstances due for execution", (Object)pickedExecutions.size());
        this.moreExecutionsInDatabase.set(pickedExecutions.size() == executionsToFetch);
        if (pickedExecutions.size() == 0) {
            LOG.trace("No executions due.");
            return;
        }
        for (Execution picked : pickedExecutions) {
            this.executor.addToQueue(new ExecutePicked(this.executor, this.taskRepository, this.schedulerClient, this.statsRegistry, this.taskResolver, this.schedulerState, this.failureLogger, this.clock, picked), () -> {
                if (this.moreExecutionsInDatabase.get() && this.executor.getNumberInQueueOrProcessing() <= this.lowerLimit) {
                    this.triggerCheckForNewExecutions.run();
                }
            });
        }
        this.statsRegistry.register(StatsRegistry.SchedulerStatsEvent.RAN_EXECUTE_DUE);
    }
}

