/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler;

import com.github.kagkarlsson.scheduler.exceptions.DataClassMismatchException;
import com.github.kagkarlsson.scheduler.task.Execution;
import com.github.kagkarlsson.scheduler.task.TaskInstanceId;
import java.time.Instant;
import java.util.Objects;

public class ScheduledExecution<DATA_TYPE> {
    private final Class<DATA_TYPE> dataClass;
    private final Execution execution;

    public ScheduledExecution(Class<DATA_TYPE> dataClass, Execution execution) {
        this.dataClass = dataClass;
        this.execution = execution;
    }

    public TaskInstanceId getTaskInstance() {
        return this.execution.taskInstance;
    }

    public Instant getExecutionTime() {
        return this.execution.getExecutionTime();
    }

    public DATA_TYPE getData() {
        if (this.dataClass.isInstance(this.execution.taskInstance.getData())) {
            return (DATA_TYPE)this.execution.taskInstance.getData();
        }
        throw new DataClassMismatchException(this.dataClass, this.execution.taskInstance.getData().getClass());
    }

    public Instant getLastSuccess() {
        return this.execution.lastSuccess;
    }

    public Instant getLastFailure() {
        return this.execution.lastFailure;
    }

    public int getConsecutiveFailures() {
        return this.execution.consecutiveFailures;
    }

    public boolean isPicked() {
        return this.execution.picked;
    }

    public String getPickedBy() {
        return this.execution.pickedBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduledExecution that = (ScheduledExecution)o;
        return Objects.equals(this.execution, that.execution);
    }

    public int hashCode() {
        return Objects.hash(this.execution);
    }

    public String toString() {
        return "ScheduledExecution{execution=" + this.execution + '}';
    }
}

