/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task.helper;

import com.github.kagkarlsson.scheduler.Clock;
import com.github.kagkarlsson.scheduler.ScheduledExecution;
import com.github.kagkarlsson.scheduler.SchedulerClient;
import com.github.kagkarlsson.scheduler.task.ExecutionComplete;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.TaskInstance;
import com.github.kagkarlsson.scheduler.task.helper.ScheduleOnStartup;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ScheduleRecurringOnStartup<T>
implements ScheduleOnStartup<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ScheduleRecurringOnStartup.class);
    private final Schedule schedule;
    private final String instance;
    private final T data;

    ScheduleRecurringOnStartup(String instance, T data, Schedule schedule) {
        this.instance = instance;
        this.data = data;
        this.schedule = schedule;
    }

    @Override
    public void apply(SchedulerClient scheduler, Clock clock, Task<T> task) {
        TaskInstance instanceWithoutData = task.instance(this.instance);
        Optional<ScheduledExecution<Object>> preexistingExecution = scheduler.getScheduledExecution(instanceWithoutData);
        if (this.schedule.isDisabled()) {
            if (preexistingExecution.isPresent()) {
                LOG.info("Task-instance '{}' has a Schedule that has been marked as disabled. Removing existing execution with execution-time '{}'.", instanceWithoutData, (Object)preexistingExecution.get().getExecutionTime());
                this.tryCancel(scheduler, instanceWithoutData);
            } else {
                LOG.info("Task-instance '{}' has a Schedule that has been marked as disabled. Will not schedule a new execution", instanceWithoutData);
            }
            return;
        }
        if (preexistingExecution.isPresent()) {
            Optional<Instant> newNextExecutionTime = this.checkForNewExecutionTime(clock, instanceWithoutData, preexistingExecution.get());
            newNextExecutionTime.ifPresent(instant -> scheduler.reschedule(instanceWithoutData, (Instant)instant));
        } else {
            Instant initialExecutionTime = this.schedule.getInitialExecutionTime(clock.now());
            LOG.info("Creating initial execution for task-instance '{}'. Next execution-time: {}", instanceWithoutData, (Object)initialExecutionTime);
            scheduler.schedule(this.getSchedulableInstance(task), initialExecutionTime);
        }
    }

    private void tryCancel(SchedulerClient scheduler, TaskInstance<T> instanceWithoutData) {
        try {
            scheduler.cancel(instanceWithoutData);
        }
        catch (RuntimeException e) {
            LOG.warn("Failed to cancel existing execution for a Task with a Scheduled marked as disabled. May happen if another instance already did it, or if it is currently executing.", (Throwable)e);
        }
    }

    Optional<Instant> checkForNewExecutionTime(Clock clock, TaskInstance<T> instanceWithoutData, ScheduledExecution<Object> preexistingExecution) {
        Instant preexistingExecutionTime = preexistingExecution.getExecutionTime();
        Instant nextExecutionTimeRelativeToNow = this.schedule.getNextExecutionTime(ExecutionComplete.simulatedSuccess(clock.now()));
        if (preexistingExecutionTime.isBefore(clock.now().plus(Duration.ofSeconds(10L)))) {
            LOG.debug("Not checking if task-instance '{}' needs rescheduling as its execution-time is too near now().", instanceWithoutData);
            return Optional.empty();
        }
        if (this.schedule.isDeterministic()) {
            Instant potentiallyNewExecutionTime = this.schedule.getNextExecutionTime(ExecutionComplete.simulatedSuccess(clock.now()));
            if (ScheduleRecurringOnStartup.differenceGreaterThan(preexistingExecutionTime, potentiallyNewExecutionTime, Duration.ofSeconds(1L))) {
                LOG.info("Rescheduling task-instance '{}' because deterministic Schedule seem to have been updated. Previous execution-time: {}, new execution-time: {}", new Object[]{instanceWithoutData, preexistingExecutionTime, potentiallyNewExecutionTime});
                return Optional.of(potentiallyNewExecutionTime);
            }
        } else if (preexistingExecutionTime.isAfter(nextExecutionTimeRelativeToNow)) {
            LOG.info("Rescheduling task-instance '{}' because non-deterministic Schedule seem to have been updated to a more frequent one. Previous execution-time: {}, new execution-time: {}", new Object[]{instanceWithoutData, preexistingExecutionTime, nextExecutionTimeRelativeToNow});
            return Optional.of(nextExecutionTimeRelativeToNow);
        }
        LOG.debug("Task-instance '{}' is already scheduled, skipping schedule-on-startup.", instanceWithoutData);
        return Optional.empty();
    }

    static boolean differenceGreaterThan(Instant preexistingExecutionTime, Instant potentiallyNewExecutionTime, Duration delta) {
        Duration difference = Duration.between(preexistingExecutionTime, potentiallyNewExecutionTime).abs();
        return difference.toMillis() > delta.toMillis();
    }

    private TaskInstance<T> getSchedulableInstance(Task<T> task) {
        if (this.data == null) {
            return task.instance(this.instance);
        }
        return task.instance(this.instance, this.data);
    }
}

