/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.logging;

import com.github.kagkarlsson.scheduler.logging.LogLevel;
import org.slf4j.Logger;

public class ConfigurableLogger {
    private final LogMethod logMethod;
    private final boolean logStackTrace;
    private static final ConfigurableLogger NO_OP_LOGGER = new NoOpLogger();

    private ConfigurableLogger(LogMethod logMethod, boolean logStackTrace) {
        this.logMethod = logMethod;
        this.logStackTrace = logStackTrace;
    }

    public static ConfigurableLogger create(Logger logger, LogLevel logLevel, boolean logStackTrace) {
        return logLevel == LogLevel.OFF ? NO_OP_LOGGER : new ConfigurableLogger(ConfigurableLogger.getLogMethod(logger, logLevel), logStackTrace);
    }

    public void log(String format, Throwable cause, Object ... arguments) {
        if (this.logStackTrace) {
            Object[] newArguments = new Object[arguments.length + 1];
            System.arraycopy(arguments, 0, newArguments, 0, arguments.length);
            newArguments[newArguments.length - 1] = cause;
            this.logMethod.log(format, newArguments);
        } else {
            this.logMethod.log(format, arguments);
        }
    }

    private static LogMethod getLogMethod(Logger logger, LogLevel logLevel) {
        LogMethod logMethod = (arg_0, arg_1) -> ((Logger)logger).debug(arg_0, arg_1);
        switch (logLevel) {
            case TRACE: {
                logMethod = (arg_0, arg_1) -> ((Logger)logger).trace(arg_0, arg_1);
                break;
            }
            case DEBUG: {
                logMethod = (arg_0, arg_1) -> ((Logger)logger).debug(arg_0, arg_1);
                break;
            }
            case INFO: {
                logMethod = (arg_0, arg_1) -> ((Logger)logger).info(arg_0, arg_1);
                break;
            }
            case WARN: {
                logMethod = (arg_0, arg_1) -> ((Logger)logger).warn(arg_0, arg_1);
                break;
            }
            case ERROR: {
                logMethod = (arg_0, arg_1) -> ((Logger)logger).error(arg_0, arg_1);
            }
        }
        return logMethod;
    }

    private static interface LogMethod {
        public void log(String var1, Object ... var2);
    }

    private static class NoOpLogger
    extends ConfigurableLogger {
        private NoOpLogger() {
            super(null, false);
        }

        @Override
        public void log(String format, Throwable cause, Object ... arguments) {
        }
    }
}

