/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task;

import com.github.kagkarlsson.scheduler.task.ExecutionComplete;
import com.github.kagkarlsson.scheduler.task.ExecutionOperations;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface DeadExecutionHandler<T> {
    public void deadExecution(ExecutionComplete var1, ExecutionOperations<T> var2);

    public static class CancelDeadExecution<T>
    implements DeadExecutionHandler<T> {
        private static final Logger LOG = LoggerFactory.getLogger(ReviveDeadExecution.class);

        @Override
        public void deadExecution(ExecutionComplete executionComplete, ExecutionOperations<T> executionOperations) {
            LOG.warn("Cancelling dead execution: " + executionComplete.getExecution());
            executionOperations.stop();
        }
    }

    public static class ReviveDeadExecution<T>
    implements DeadExecutionHandler<T> {
        private static final Logger LOG = LoggerFactory.getLogger(ReviveDeadExecution.class);

        @Override
        public void deadExecution(ExecutionComplete executionComplete, ExecutionOperations<T> executionOperations) {
            Instant now = Instant.now();
            LOG.info("Reviving dead execution: " + executionComplete.getExecution() + " to " + now);
            executionOperations.reschedule(executionComplete, now);
        }
    }
}

