/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.jdbc;

import com.github.kagkarlsson.scheduler.jdbc.DefaultJdbcCustomization;
import com.github.kagkarlsson.scheduler.jdbc.JdbcCustomization;
import com.github.kagkarlsson.scheduler.jdbc.JdbcTaskRepositoryContext;
import com.github.kagkarlsson.scheduler.jdbc.MariaDBJdbcCustomization;
import com.github.kagkarlsson.scheduler.jdbc.MssqlJdbcCustomization;
import com.github.kagkarlsson.scheduler.jdbc.MySQL8JdbcCustomization;
import com.github.kagkarlsson.scheduler.jdbc.MySQLJdbcCustomization;
import com.github.kagkarlsson.scheduler.jdbc.OracleJdbcCustomization;
import com.github.kagkarlsson.scheduler.jdbc.PostgreSqlJdbcCustomization;
import com.github.kagkarlsson.scheduler.task.Execution;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutodetectJdbcCustomization
implements JdbcCustomization {
    private static final Logger LOG = LoggerFactory.getLogger(AutodetectJdbcCustomization.class);
    public static final String MICROSOFT_SQL_SERVER = "Microsoft SQL Server";
    public static final String POSTGRESQL = "PostgreSQL";
    public static final String ORACLE = "Oracle";
    public static final String MYSQL = "MySQL";
    public static final String MARIADB = "MariaDB";
    private final JdbcCustomization jdbcCustomization;

    public AutodetectJdbcCustomization(DataSource dataSource) {
        DefaultJdbcCustomization detectedCustomization = new DefaultJdbcCustomization();
        LOG.debug("Detecting database...");
        try (Connection c = dataSource.getConnection();){
            String databaseProductName = c.getMetaData().getDatabaseProductName();
            LOG.info("Detected database {}.", (Object)databaseProductName);
            if (databaseProductName.equals(MICROSOFT_SQL_SERVER)) {
                LOG.info("Using MSSQL jdbc-overrides.");
                detectedCustomization = new MssqlJdbcCustomization();
            } else if (databaseProductName.equals(POSTGRESQL)) {
                LOG.info("Using PostgreSQL jdbc-overrides.");
                detectedCustomization = new PostgreSqlJdbcCustomization();
            } else if (databaseProductName.contains(ORACLE)) {
                LOG.info("Using Oracle jdbc-overrides.");
                detectedCustomization = new OracleJdbcCustomization();
            } else if (databaseProductName.contains(MARIADB)) {
                LOG.info("Using MariaDB jdbc-overrides.");
                detectedCustomization = new MariaDBJdbcCustomization();
            } else if (databaseProductName.contains(MYSQL)) {
                int databaseMajorVersion = c.getMetaData().getDatabaseMajorVersion();
                String dbVersion = c.getMetaData().getDatabaseProductVersion();
                if (databaseMajorVersion >= 8) {
                    LOG.info("Using MySQL jdbc-overrides version 8 and later. (v {})", (Object)dbVersion);
                    detectedCustomization = new MySQL8JdbcCustomization();
                } else {
                    LOG.info("Using MySQL jdbc-overrides for version older than 8. (v {})", (Object)dbVersion);
                    detectedCustomization = new MySQLJdbcCustomization();
                }
            }
        }
        catch (SQLException e) {
            LOG.error("Failed to detect database via getDatabaseMetadata. Using default.", (Throwable)e);
        }
        this.jdbcCustomization = detectedCustomization;
    }

    @Override
    public void setInstant(PreparedStatement p, int index, Instant value) throws SQLException {
        this.jdbcCustomization.setInstant(p, index, value);
    }

    @Override
    public Instant getInstant(ResultSet rs, String columnName) throws SQLException {
        return this.jdbcCustomization.getInstant(rs, columnName);
    }

    @Override
    public void setTaskData(PreparedStatement p, int index, byte[] value) throws SQLException {
        this.jdbcCustomization.setTaskData(p, index, value);
    }

    @Override
    public byte[] getTaskData(ResultSet rs, String columnName) throws SQLException {
        return this.jdbcCustomization.getTaskData(rs, columnName);
    }

    @Override
    public boolean supportsExplicitQueryLimitPart() {
        return this.jdbcCustomization.supportsExplicitQueryLimitPart();
    }

    @Override
    public String getQueryLimitPart(int limit) {
        return this.jdbcCustomization.getQueryLimitPart(limit);
    }

    @Override
    public boolean supportsSingleStatementLockAndFetch() {
        return this.jdbcCustomization.supportsSingleStatementLockAndFetch();
    }

    @Override
    public List<Execution> lockAndFetchSingleStatement(JdbcTaskRepositoryContext ctx, Instant now, int limit) {
        return this.jdbcCustomization.lockAndFetchSingleStatement(ctx, now, limit);
    }

    @Override
    public boolean supportsGenericLockAndFetch() {
        return this.jdbcCustomization.supportsGenericLockAndFetch();
    }

    @Override
    public String createGenericSelectForUpdateQuery(String tableName, int limit, String requiredAndCondition) {
        return this.jdbcCustomization.createGenericSelectForUpdateQuery(tableName, limit, requiredAndCondition);
    }

    @Override
    public String createSelectDueQuery(String tableName, int limit, String andCondition) {
        return this.jdbcCustomization.createSelectDueQuery(tableName, limit, andCondition);
    }

    @Override
    public String getName() {
        return this.jdbcCustomization.getName();
    }
}

