/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task.helper;

import com.github.kagkarlsson.scheduler.task.AbstractTask;
import com.github.kagkarlsson.scheduler.task.CompletionHandler;
import com.github.kagkarlsson.scheduler.task.DeadExecutionHandler;
import com.github.kagkarlsson.scheduler.task.ExecutionContext;
import com.github.kagkarlsson.scheduler.task.FailureHandler;
import com.github.kagkarlsson.scheduler.task.SchedulableInstance;
import com.github.kagkarlsson.scheduler.task.SchedulableTaskInstance;
import com.github.kagkarlsson.scheduler.task.TaskInstance;
import java.time.Duration;

public abstract class OneTimeTask<T>
extends AbstractTask<T> {
    public OneTimeTask(String name, Class<T> dataClass) {
        this(name, dataClass, new FailureHandler.OnFailureRetryLater(Duration.ofMinutes(5L)), new DeadExecutionHandler.ReviveDeadExecution());
    }

    public OneTimeTask(String name, Class<T> dataClass, FailureHandler<T> failureHandler) {
        this(name, dataClass, failureHandler, new DeadExecutionHandler.ReviveDeadExecution());
    }

    public OneTimeTask(String name, Class<T> dataClass, FailureHandler<T> failureHandler, DeadExecutionHandler<T> deadExecutionHandler) {
        super(name, dataClass, failureHandler, deadExecutionHandler);
    }

    @Override
    public SchedulableInstance<T> schedulableInstance(String id) {
        return new SchedulableTaskInstance(new TaskInstance(this.getName(), id), currentTime -> currentTime);
    }

    @Override
    public SchedulableInstance<T> schedulableInstance(String id, T data) {
        return new SchedulableTaskInstance<T>(new TaskInstance<T>(this.getName(), id, data), currentTime -> currentTime);
    }

    @Override
    public CompletionHandler<T> execute(TaskInstance<T> taskInstance, ExecutionContext executionContext) {
        this.executeOnce(taskInstance, executionContext);
        return new CompletionHandler.OnCompleteRemove();
    }

    public abstract void executeOnce(TaskInstance<T> var1, ExecutionContext var2);

    @Override
    public String toString() {
        return "OneTimeTask name=" + this.getName();
    }
}

