/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task;

import com.github.kagkarlsson.scheduler.task.TaskInstance;
import com.github.kagkarlsson.scheduler.task.TaskInstanceId;
import java.time.Instant;
import java.util.Objects;

public final class Execution
implements TaskInstanceId {
    public final TaskInstance taskInstance;
    public final Instant executionTime;
    public final boolean picked;
    public final String pickedBy;
    public int consecutiveFailures;
    public final Instant lastHeartbeat;
    public final long version;
    public final Instant lastFailure;
    public final Instant lastSuccess;

    public Execution(Instant executionTime, TaskInstance taskInstance) {
        this(executionTime, taskInstance, false, null, null, null, 0, null, 1L);
    }

    public Execution(Instant executionTime, TaskInstance taskInstance, boolean picked, String pickedBy, Instant lastSuccess, Instant lastFailure, int consecutiveFailures, Instant lastHeartbeat, long version) {
        this.executionTime = executionTime;
        this.taskInstance = taskInstance;
        this.picked = picked;
        this.pickedBy = pickedBy;
        this.lastFailure = lastFailure;
        this.lastSuccess = lastSuccess;
        this.consecutiveFailures = consecutiveFailures;
        this.lastHeartbeat = lastHeartbeat;
        this.version = version;
    }

    public Instant getExecutionTime() {
        return this.executionTime;
    }

    public boolean isPicked() {
        return this.picked;
    }

    public Execution updateToPicked(String newPickedBy, Instant newLastHeartbeat) {
        return new Execution(this.executionTime, this.taskInstance, true, newPickedBy, this.lastSuccess, this.lastFailure, this.consecutiveFailures, newLastHeartbeat, this.version + 1L);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Execution execution = (Execution)o;
        return Objects.equals(this.executionTime, execution.executionTime) && Objects.equals(this.taskInstance, execution.taskInstance);
    }

    public int hashCode() {
        return Objects.hash(this.executionTime, this.taskInstance);
    }

    public String toString() {
        return "Execution: task=" + this.taskInstance.getTaskName() + ", id=" + this.taskInstance.getId() + ", executionTime=" + this.executionTime + ", picked=" + this.picked + ", pickedBy=" + this.pickedBy + ", lastHeartbeat=" + this.lastHeartbeat + ", version=" + this.version;
    }

    @Override
    public String getTaskName() {
        return this.taskInstance.getTaskName();
    }

    @Override
    public String getId() {
        return this.taskInstance.getId();
    }
}

