/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task.helper;

import com.github.kagkarlsson.scheduler.Clock;
import com.github.kagkarlsson.scheduler.SchedulerClient;
import com.github.kagkarlsson.scheduler.task.CompletionHandler;
import com.github.kagkarlsson.scheduler.task.DeadExecutionHandler;
import com.github.kagkarlsson.scheduler.task.ExecutionComplete;
import com.github.kagkarlsson.scheduler.task.ExecutionContext;
import com.github.kagkarlsson.scheduler.task.ExecutionHandler;
import com.github.kagkarlsson.scheduler.task.FailureHandler;
import com.github.kagkarlsson.scheduler.task.StateReturningExecutionHandler;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.TaskDescriptor;
import com.github.kagkarlsson.scheduler.task.TaskInstance;
import com.github.kagkarlsson.scheduler.task.VoidExecutionHandler;
import com.github.kagkarlsson.scheduler.task.helper.CustomTask;
import com.github.kagkarlsson.scheduler.task.helper.OneTimeTask;
import com.github.kagkarlsson.scheduler.task.helper.RecurringTask;
import com.github.kagkarlsson.scheduler.task.helper.RecurringTaskWithPersistentSchedule;
import com.github.kagkarlsson.scheduler.task.helper.ScheduleAndData;
import com.github.kagkarlsson.scheduler.task.helper.ScheduleOnStartup;
import com.github.kagkarlsson.scheduler.task.helper.ScheduleOnceOnStartup;
import com.github.kagkarlsson.scheduler.task.helper.ScheduleRecurringOnStartup;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Function;

public class Tasks {
    public static final Duration DEFAULT_RETRY_INTERVAL = Duration.ofMinutes(5L);

    public static RecurringTaskBuilder<Void> recurring(String name, Schedule schedule) {
        return Tasks.recurring(TaskDescriptor.of(name, Void.class), schedule);
    }

    public static <T> RecurringTaskBuilder<T> recurring(String name, Schedule schedule, Class<T> dataClass) {
        return Tasks.recurring(TaskDescriptor.of(name, dataClass), schedule);
    }

    public static <T> RecurringTaskBuilder<T> recurring(TaskDescriptor<T> descriptor, Schedule schedule) {
        return new RecurringTaskBuilder<T>(descriptor.getTaskName(), schedule, descriptor.getDataClass());
    }

    public static <T extends ScheduleAndData> RecurringTaskWithPersistentScheduleBuilder<T> recurringWithPersistentSchedule(String name, Class<T> dataClass) {
        return Tasks.recurringWithPersistentSchedule(TaskDescriptor.of(name, dataClass));
    }

    public static <T extends ScheduleAndData> RecurringTaskWithPersistentScheduleBuilder<T> recurringWithPersistentSchedule(TaskDescriptor<T> descriptor) {
        return new RecurringTaskWithPersistentScheduleBuilder<T>(descriptor.getTaskName(), descriptor.getDataClass());
    }

    public static OneTimeTaskBuilder<Void> oneTime(String name) {
        return Tasks.oneTime(TaskDescriptor.of(name, Void.class));
    }

    public static <T> OneTimeTaskBuilder<T> oneTime(String name, Class<T> dataClass) {
        return Tasks.oneTime(TaskDescriptor.of(name, dataClass));
    }

    public static <T> OneTimeTaskBuilder<T> oneTime(TaskDescriptor<T> descriptor) {
        return new OneTimeTaskBuilder<T>(descriptor.getTaskName(), descriptor.getDataClass());
    }

    public static <T> TaskBuilder<T> custom(String name, Class<T> dataClass) {
        return new TaskBuilder<T>(name, dataClass);
    }

    public static <T> TaskBuilder<T> custom(TaskDescriptor<T> taskDescriptor) {
        return new TaskBuilder<T>(taskDescriptor.getTaskName(), taskDescriptor.getDataClass());
    }

    public static class TaskBuilder<T> {
        private final String name;
        private final Class<T> dataClass;
        private FailureHandler<T> onFailure;
        private DeadExecutionHandler<T> onDeadExecution;
        private ScheduleOnStartup<T> onStartup;
        private Function<Instant, Instant> defaultExecutionTime = Function.identity();

        public TaskBuilder(String name, Class<T> dataClass) {
            this.name = name;
            this.dataClass = dataClass;
            this.onDeadExecution = new DeadExecutionHandler.ReviveDeadExecution();
            this.onFailure = new FailureHandler.OnFailureRetryLater(DEFAULT_RETRY_INTERVAL);
        }

        public TaskBuilder<T> onFailureReschedule(Schedule schedule) {
            this.onFailure = new FailureHandler.OnFailureReschedule(schedule);
            return this;
        }

        public TaskBuilder<T> onDeadExecutionRevive() {
            this.onDeadExecution = new DeadExecutionHandler.ReviveDeadExecution();
            return this;
        }

        public TaskBuilder<T> onFailure(FailureHandler<T> failureHandler) {
            this.onFailure = failureHandler;
            return this;
        }

        public TaskBuilder<T> onDeadExecution(DeadExecutionHandler<T> deadExecutionHandler) {
            this.onDeadExecution = deadExecutionHandler;
            return this;
        }

        public TaskBuilder<T> scheduleOnStartup(String instance, T initialData, Function<Instant, Instant> firstExecutionTime) {
            this.onStartup = new ScheduleOnceOnStartup<T>(instance, initialData, firstExecutionTime);
            return this;
        }

        public TaskBuilder<T> scheduleOnStartup(String instance, T initialData, Schedule schedule) {
            this.onStartup = new ScheduleOnceOnStartup<T>(instance, initialData, now -> schedule.getNextExecutionTime(ExecutionComplete.simulatedSuccess(now)));
            return this;
        }

        public TaskBuilder<T> defaultExecutionTime(Function<Instant, Instant> defaultExecutionTime) {
            this.defaultExecutionTime = defaultExecutionTime;
            return this;
        }

        public CustomTask<T> execute(final ExecutionHandler<T> executionHandler) {
            return new CustomTask<T>(this.name, this.dataClass, this.onStartup, this.defaultExecutionTime, this.onFailure, this.onDeadExecution){

                @Override
                public CompletionHandler<T> execute(TaskInstance<T> taskInstance, ExecutionContext executionContext) {
                    return executionHandler.execute(taskInstance, executionContext);
                }
            };
        }
    }

    public static class OneTimeTaskBuilder<T> {
        private final String name;
        private final Class<T> dataClass;
        private FailureHandler<T> onFailure;
        private DeadExecutionHandler<T> onDeadExecution;

        public OneTimeTaskBuilder(String name, Class<T> dataClass) {
            this.name = name;
            this.dataClass = dataClass;
            this.onDeadExecution = new DeadExecutionHandler.ReviveDeadExecution();
            this.onFailure = new FailureHandler.OnFailureRetryLater(DEFAULT_RETRY_INTERVAL);
        }

        public OneTimeTaskBuilder<T> onFailureRetryLater() {
            this.onFailure = new FailureHandler.OnFailureRetryLater(DEFAULT_RETRY_INTERVAL);
            return this;
        }

        public OneTimeTaskBuilder<T> onDeadExecutionRevive() {
            this.onDeadExecution = new DeadExecutionHandler.ReviveDeadExecution();
            return this;
        }

        public OneTimeTaskBuilder<T> onFailure(FailureHandler<T> failureHandler) {
            this.onFailure = failureHandler;
            return this;
        }

        public OneTimeTaskBuilder<T> onDeadExecution(DeadExecutionHandler<T> deadExecutionHandler) {
            this.onDeadExecution = deadExecutionHandler;
            return this;
        }

        public OneTimeTask<T> execute(final VoidExecutionHandler<T> executionHandler) {
            return new OneTimeTask<T>(this.name, this.dataClass, this.onFailure, this.onDeadExecution){

                @Override
                public void executeOnce(TaskInstance<T> taskInstance, ExecutionContext executionContext) {
                    executionHandler.execute(taskInstance, executionContext);
                }
            };
        }
    }

    public static class RecurringTaskWithPersistentScheduleBuilder<T extends ScheduleAndData> {
        private final String name;
        private final Class<T> dataClass;
        private FailureHandler<T> onFailure = new FailureHandler.OnFailureRescheduleUsingTaskDataSchedule();

        public RecurringTaskWithPersistentScheduleBuilder(String name, Class<T> dataClass) {
            this.name = name;
            this.dataClass = dataClass;
        }

        public RecurringTaskWithPersistentScheduleBuilder<T> onFailure(FailureHandler<T> failureHandler) {
            this.onFailure = failureHandler;
            return this;
        }

        public RecurringTaskWithPersistentSchedule<T> execute(final VoidExecutionHandler<T> executionHandler) {
            return new RecurringTaskWithPersistentSchedule<T>(this.name, this.dataClass, this.onFailure){

                @Override
                public CompletionHandler<T> execute(TaskInstance<T> taskInstance, ExecutionContext executionContext) {
                    executionHandler.execute(taskInstance, executionContext);
                    return (executionComplete, executionOperations) -> executionOperations.reschedule(executionComplete, ((ScheduleAndData)taskInstance.getData()).getSchedule().getNextExecutionTime(executionComplete));
                }
            };
        }

        public RecurringTaskWithPersistentSchedule<T> executeStateful(final StateReturningExecutionHandler<T> executionHandler) {
            return new RecurringTaskWithPersistentSchedule<T>(this.name, this.dataClass, this.onFailure){

                @Override
                public CompletionHandler<T> execute(TaskInstance<T> taskInstance, ExecutionContext executionContext) {
                    ScheduleAndData nextData = (ScheduleAndData)executionHandler.execute(taskInstance, executionContext);
                    return (executionComplete, executionOperations) -> executionOperations.reschedule(executionComplete, nextData.getSchedule().getNextExecutionTime(executionComplete), nextData);
                }
            };
        }
    }

    public static class RecurringTaskBuilder<T> {
        private final String name;
        private final Schedule schedule;
        private final Class<T> dataClass;
        private FailureHandler<T> onFailure;
        private DeadExecutionHandler<T> onDeadExecution;
        private ScheduleRecurringOnStartup<T> scheduleOnStartup;

        public RecurringTaskBuilder(String name, Schedule schedule, Class<T> dataClass) {
            this.name = name;
            this.schedule = schedule;
            this.dataClass = dataClass;
            this.onFailure = new FailureHandler.OnFailureReschedule(schedule);
            this.onDeadExecution = new DeadExecutionHandler.ReviveDeadExecution();
            this.scheduleOnStartup = new ScheduleRecurringOnStartup<Object>("recurring", null, schedule);
        }

        public RecurringTaskBuilder<T> onFailureReschedule() {
            this.onFailure = new FailureHandler.OnFailureReschedule(this.schedule);
            return this;
        }

        public RecurringTaskBuilder<T> onDeadExecutionRevive() {
            this.onDeadExecution = new DeadExecutionHandler.ReviveDeadExecution();
            return this;
        }

        public RecurringTaskBuilder<T> onFailure(FailureHandler<T> failureHandler) {
            this.onFailure = failureHandler;
            return this;
        }

        public RecurringTaskBuilder<T> onDeadExecution(DeadExecutionHandler<T> deadExecutionHandler) {
            this.onDeadExecution = deadExecutionHandler;
            return this;
        }

        public RecurringTaskBuilder<T> initialData(T initialData) {
            this.scheduleOnStartup = new ScheduleRecurringOnStartup<T>("recurring", initialData, this.schedule);
            return this;
        }

        public RecurringTaskBuilder<T> doNotScheduleOnStartup() {
            this.scheduleOnStartup = new ScheduleRecurringOnStartup<T>("recurring", null, null){

                @Override
                public void apply(SchedulerClient scheduler, Clock clock, Task<T> task) {
                }
            };
            return this;
        }

        public RecurringTask<T> execute(final VoidExecutionHandler<T> executionHandler) {
            return new RecurringTask<T>(this.name, this.schedule, this.dataClass, this.scheduleOnStartup, this.onFailure, this.onDeadExecution){

                @Override
                public void executeRecurringly(TaskInstance<T> taskInstance, ExecutionContext executionContext) {
                    executionHandler.execute(taskInstance, executionContext);
                }
            };
        }

        public RecurringTask<T> executeStateful(final StateReturningExecutionHandler<T> executionHandler) {
            return new RecurringTask<T>(this.name, this.schedule, this.dataClass, this.scheduleOnStartup, this.onFailure, this.onDeadExecution){

                @Override
                public CompletionHandler<T> execute(TaskInstance<T> taskInstance, ExecutionContext executionContext) {
                    Object nextData = executionHandler.execute(taskInstance, executionContext);
                    return new CompletionHandler.OnCompleteReschedule(schedule, nextData);
                }

                @Override
                public void executeRecurringly(TaskInstance<T> taskInstance, ExecutionContext executionContext) {
                }
            };
        }
    }
}

