/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.shaded.jdbc;

import com.github.kagkarlsson.shaded.jdbc.BatchPreparedStatementSetter;
import com.github.kagkarlsson.shaded.jdbc.ConnectionSupplier;
import com.github.kagkarlsson.shaded.jdbc.DataSourceConnectionSupplier;
import com.github.kagkarlsson.shaded.jdbc.ExternallyManagedConnection;
import com.github.kagkarlsson.shaded.jdbc.IntegrityConstraintViolation;
import com.github.kagkarlsson.shaded.jdbc.PreparedStatementExecutor;
import com.github.kagkarlsson.shaded.jdbc.PreparedStatementSetter;
import com.github.kagkarlsson.shaded.jdbc.ResultSetMapper;
import com.github.kagkarlsson.shaded.jdbc.RowMapper;
import com.github.kagkarlsson.shaded.jdbc.SQLRuntimeException;
import com.github.kagkarlsson.shaded.jdbc.ThreadLocalTransactionContextProvider;
import com.github.kagkarlsson.shaded.jdbc.TransactionContextProvider;
import com.github.kagkarlsson.shaded.jdbc.TransactionManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcRunner {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcRunner.class);
    private final ConnectionSupplier connectionSupplier;
    private final TransactionContextProvider transactionContextProvider;

    public JdbcRunner(DataSource dataSource) {
        this(dataSource, false);
    }

    public JdbcRunner(DataSource dataSource, boolean commitWhenAutocommitDisabled) {
        this(new DataSourceConnectionSupplier(dataSource, commitWhenAutocommitDisabled), new ThreadLocalTransactionContextProvider());
    }

    public JdbcRunner(DataSource dataSource, boolean commitWhenAutocommitDisabled, TransactionContextProvider transactionContextProvider) {
        this(new DataSourceConnectionSupplier(dataSource, commitWhenAutocommitDisabled), transactionContextProvider);
    }

    public JdbcRunner(ConnectionSupplier connectionSupplier, TransactionContextProvider transactionContextProvider) {
        this.connectionSupplier = connectionSupplier;
        this.transactionContextProvider = transactionContextProvider;
    }

    public <T> T inTransaction(Function<JdbcRunner, T> doInTransaction) {
        return (T)new TransactionManager(this.connectionSupplier, this.transactionContextProvider).inTransaction((Connection c) -> {
            JdbcRunner jdbc = new JdbcRunner(new ExternallyManagedConnection(c), this.transactionContextProvider);
            return doInTransaction.apply(jdbc);
        });
    }

    public int execute(String query, PreparedStatementSetter setParameters) {
        return (Integer)this.execute(query, setParameters, PreparedStatementExecutor.EXECUTE, new AfterExecution.ReturnStatementUpdateCount());
    }

    public <T> List<T> query(String query, PreparedStatementSetter setParameters, RowMapper<T> rowMapper) {
        return this.execute(query, setParameters, PreparedStatementExecutor.EXECUTE, (p, executeResult) -> this.mapResultSet(p, rowMapper));
    }

    public <T> T query(String query, PreparedStatementSetter setParameters, ResultSetMapper<T> resultSetMapper) {
        return (T)this.execute(query, setParameters, PreparedStatementExecutor.EXECUTE, (p, executeResult) -> this.mapResultSet(p, resultSetMapper));
    }

    public <T> T execute(String query, PreparedStatementSetter setParameters, AfterExecution<T, Boolean> afterExecution) {
        return this.execute(query, setParameters, PreparedStatementExecutor.EXECUTE, afterExecution);
    }

    public <U> int[] executeBatch(String query, List<U> batchValues, BatchPreparedStatementSetter<U> setParameters) {
        PreparedStatementSetter setAllBatches = preparedStatement -> {
            for (Object batchValue : batchValues) {
                setParameters.setParametersForRow(batchValue, preparedStatement);
                preparedStatement.addBatch();
            }
        };
        return this.execute(query, setAllBatches, PreparedStatementExecutor.EXECUTE_BATCH, (executedPreparedStatement, executeResult) -> executeResult);
    }

    private <T, U> T execute(String query, PreparedStatementSetter setParameters, PreparedStatementExecutor<U> executePreparedStatement, AfterExecution<T, U> afterExecution) {
        return (T)this.withConnection(c -> {
            PreparedStatement preparedStatement = null;
            try {
                try {
                    preparedStatement = c.prepareStatement(query);
                }
                catch (SQLException e) {
                    throw new SQLRuntimeException("Error when preparing statement.", e);
                }
                try {
                    LOG.trace("Setting parameters of prepared statement.");
                    setParameters.setParameters(preparedStatement);
                }
                catch (SQLException e) {
                    throw new SQLRuntimeException(e);
                }
                try {
                    LOG.trace("Executing prepared statement");
                    Object executeResult = executePreparedStatement.execute(preparedStatement);
                    Object t = afterExecution.doAfterExecution(preparedStatement, executeResult);
                    return t;
                }
                catch (SQLException e) {
                    throw this.translateException(e);
                }
            }
            finally {
                this.nonThrowingClose(preparedStatement);
            }
        });
    }

    private void commitIfNecessary(Connection c) {
        try {
            if (this.shouldManageTransaction(c)) {
                c.commit();
            }
        }
        catch (SQLException e) {
            throw new SQLRuntimeException("Failed to commit.", e);
        }
    }

    private RuntimeException rollbackIfNecessary(Connection c, RuntimeException originalException) {
        try {
            if (this.shouldManageTransaction(c)) {
                c.rollback();
            }
            return originalException;
        }
        catch (SQLException e) {
            SQLRuntimeException rollbackException = new SQLRuntimeException("Failed to rollback.", e);
            rollbackException.addSuppressed(originalException);
            return rollbackException;
        }
    }

    private boolean shouldManageTransaction(Connection c) throws SQLException {
        if (this.connectionSupplier.isExternallyManagedConnection()) {
            return false;
        }
        if (c.getAutoCommit()) {
            return false;
        }
        return this.connectionSupplier.commitWhenAutocommitDisabled();
    }

    private SQLRuntimeException translateException(SQLException ex) {
        if (ex instanceof SQLIntegrityConstraintViolationException) {
            return new IntegrityConstraintViolation(ex);
        }
        return new SQLRuntimeException(ex);
    }

    private <T> T withConnection(Function<Connection, T> doWithConnection) {
        Connection c;
        try {
            LOG.trace("Getting connection from datasource");
            c = this.connectionSupplier.getConnection();
        }
        catch (SQLException e) {
            throw new SQLRuntimeException("Unable to open connection", e);
        }
        try {
            T result = doWithConnection.apply(c);
            this.commitIfNecessary(c);
            T t = result;
            return t;
        }
        catch (RuntimeException e) {
            throw this.rollbackIfNecessary(c, e);
        }
        finally {
            if (!this.connectionSupplier.isExternallyManagedConnection()) {
                this.nonThrowingClose(c);
            }
        }
    }

    private <T> List<T> mapResultSet(PreparedStatement executedPreparedStatement, RowMapper<T> rowMapper) {
        return this.withResultSet(executedPreparedStatement, rs -> {
            ArrayList results = new ArrayList();
            while (rs.next()) {
                results.add(rowMapper.map(rs));
            }
            return results;
        });
    }

    private <T> T mapResultSet(PreparedStatement executedPreparedStatement, ResultSetMapper<T> resultSetMapper) {
        return (T)this.withResultSet(executedPreparedStatement, rs -> resultSetMapper.map(rs));
    }

    private <T> T withResultSet(PreparedStatement executedPreparedStatement, DoWithResultSet<T> doWithResultSet) {
        ResultSet rs = null;
        try {
            try {
                rs = executedPreparedStatement.getResultSet();
            }
            catch (SQLException e) {
                throw new SQLRuntimeException(e);
            }
            try {
                T e = doWithResultSet.withResultSet(rs);
            }
            catch (SQLException e) {
                throw new SQLRuntimeException(e);
            }
            return e;
        }
        finally {
            this.nonThrowingClose(rs);
        }
    }

    private void nonThrowingClose(AutoCloseable toClose) {
        if (toClose == null) {
            return;
        }
        try {
            LOG.trace("Closing " + toClose.getClass().getSimpleName());
            toClose.close();
        }
        catch (Exception e) {
            LOG.warn("Exception on close of " + toClose.getClass().getSimpleName(), (Throwable)e);
        }
    }

    static interface AfterExecution<T, U> {
        public T doAfterExecution(PreparedStatement var1, U var2) throws SQLException;

        public static class ReturnStatementUpdateCount<U>
        implements AfterExecution<Integer, U> {
            @Override
            public Integer doAfterExecution(PreparedStatement executedPreparedStatement, U executeResult) throws SQLException {
                return executedPreparedStatement.getUpdateCount();
            }
        }
    }

    static interface DoWithResultSet<T> {
        public T withResultSet(ResultSet var1) throws SQLException;
    }
}

