/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler;

import com.github.kagkarlsson.scheduler.Clock;
import com.github.kagkarlsson.scheduler.SystemClock;
import com.github.kagkarlsson.scheduler.stats.StatsRegistry;
import com.github.kagkarlsson.scheduler.task.Task;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskResolver {
    private static final Logger LOG = LoggerFactory.getLogger(TaskResolver.class);
    private final StatsRegistry statsRegistry;
    private final Clock clock;
    private final Map<String, Task> taskMap;
    private final Map<String, UnresolvedTask> unresolvedTasks = new ConcurrentHashMap<String, UnresolvedTask>();

    public TaskResolver(StatsRegistry statsRegistry, Task<?> ... knownTasks) {
        this(statsRegistry, Arrays.asList(knownTasks));
    }

    public TaskResolver(StatsRegistry statsRegistry, List<Task<?>> knownTasks) {
        this(statsRegistry, new SystemClock(), knownTasks);
    }

    public TaskResolver(StatsRegistry statsRegistry, Clock clock, List<Task<?>> knownTasks) {
        this.statsRegistry = statsRegistry;
        this.clock = clock;
        this.taskMap = knownTasks.stream().collect(Collectors.toMap(Task::getName, Function.identity()));
    }

    public Optional<Task> resolve(String taskName) {
        return this.resolve(taskName, true);
    }

    public Optional<Task> resolve(String taskName, boolean addUnresolvedToExclusionFilter) {
        Task task = this.taskMap.get(taskName);
        if (task == null && addUnresolvedToExclusionFilter) {
            this.addUnresolved(taskName);
            this.statsRegistry.register(StatsRegistry.SchedulerStatsEvent.UNRESOLVED_TASK);
            LOG.info("Found execution with unknown task-name '{}'. Adding it to the list of known unresolved task-names.", (Object)taskName);
        }
        return Optional.ofNullable(task);
    }

    private void addUnresolved(String taskName) {
        this.unresolvedTasks.putIfAbsent(taskName, new UnresolvedTask(taskName));
    }

    public void addTask(Task task) {
        this.taskMap.put(task.getName(), task);
    }

    public List<UnresolvedTask> getUnresolved() {
        return new ArrayList<UnresolvedTask>(this.unresolvedTasks.values());
    }

    public List<String> getUnresolvedTaskNames(Duration unresolvedFor) {
        return this.unresolvedTasks.values().stream().filter(unresolved -> Duration.between(unresolved.firstUnresolved, this.clock.now()).toMillis() > unresolvedFor.toMillis()).map(UnresolvedTask::getTaskName).collect(Collectors.toList());
    }

    public void clearUnresolved(String taskName) {
        this.unresolvedTasks.remove(taskName);
    }

    public class UnresolvedTask {
        private final String taskName;
        private final Instant firstUnresolved;

        public UnresolvedTask(String taskName) {
            this.taskName = taskName;
            this.firstUnresolved = TaskResolver.this.clock.now();
        }

        public String getTaskName() {
            return this.taskName;
        }
    }
}

