/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task.schedule;

import com.github.kagkarlsson.scheduler.task.ExecutionComplete;
import com.github.kagkarlsson.scheduler.task.schedule.CronStyle;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import com.github.kagkarlsson.shaded.cronutils.model.Cron;
import com.github.kagkarlsson.shaded.cronutils.model.CronType;
import com.github.kagkarlsson.shaded.cronutils.model.definition.CronDefinitionBuilder;
import com.github.kagkarlsson.shaded.cronutils.model.time.ExecutionTime;
import com.github.kagkarlsson.shaded.cronutils.parser.CronParser;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CronSchedule
implements Schedule,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DISABLED = "-";
    private static final Logger LOG = LoggerFactory.getLogger(CronSchedule.class);
    private final String pattern;
    private final ZoneId zoneId;
    private final CronStyle cronStyle;
    private transient ExecutionTime cronExecutionTime;

    private CronSchedule() {
        this.pattern = null;
        this.zoneId = ZoneId.systemDefault();
        this.cronStyle = CronStyle.SPRING53;
    }

    public CronSchedule(String pattern) {
        this(pattern, ZoneId.systemDefault());
    }

    public CronSchedule(String pattern, ZoneId zoneId) {
        this(pattern, zoneId, CronStyle.SPRING53);
    }

    public CronSchedule(String pattern, ZoneId zoneId, CronStyle cronStyle) {
        this.pattern = pattern;
        CronStyle cronStyle2 = this.cronStyle = cronStyle != null ? cronStyle : CronStyle.SPRING53;
        if (zoneId == null) {
            throw new IllegalArgumentException("zoneId may not be null");
        }
        this.zoneId = zoneId;
        this.lazyInitExecutionTime();
    }

    @Override
    public Instant getNextExecutionTime(ExecutionComplete executionComplete) {
        this.lazyInitExecutionTime();
        ZonedDateTime lastDone = ZonedDateTime.ofInstant(executionComplete.getTimeDone(), this.zoneId);
        Optional<ZonedDateTime> nextTime = this.cronExecutionTime.nextExecution(lastDone);
        if (!nextTime.isPresent()) {
            LOG.error("Cron-pattern did not return any further execution-times. This behavior is currently not supported by the scheduler. Setting next execution-time to far-future, aka \"NEVER\" ({})", (Object)NEVER);
            return Schedule.NEVER;
        }
        return nextTime.get().toInstant();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInitExecutionTime() {
        if (this.cronExecutionTime != null) {
            return;
        }
        CronSchedule cronSchedule = this;
        synchronized (cronSchedule) {
            if (this.cronExecutionTime == null) {
                if (this.isDisabled()) {
                    this.cronExecutionTime = new DisabledScheduleExecutionTime();
                } else {
                    CronParser parser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor(this.cronStyle == null ? this.getCronType(CronStyle.SPRING53) : this.getCronType(this.cronStyle)));
                    Cron cron = parser.parse(this.pattern);
                    this.cronExecutionTime = ExecutionTime.forCron(cron);
                }
            }
        }
    }

    private CronType getCronType(CronStyle cronStyle) {
        switch (cronStyle) {
            case CRON4J: {
                return CronType.CRON4J;
            }
            case QUARTZ: {
                return CronType.QUARTZ;
            }
            case UNIX: {
                return CronType.UNIX;
            }
            case SPRING: {
                return CronType.SPRING;
            }
            case SPRING53: {
                return CronType.SPRING53;
            }
        }
        throw new IllegalArgumentException(String.format("No cron definition found for %s", new Object[]{this.cronStyle}));
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CronSchedule)) {
            return false;
        }
        CronSchedule that = (CronSchedule)o;
        return Objects.equals((Object)this.cronStyle, (Object)that.cronStyle) && Objects.equals(this.zoneId, that.zoneId) && Objects.equals(this.pattern, that.pattern);
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.cronStyle, this.zoneId, this.pattern});
    }

    public String toString() {
        return "CronSchedule pattern=" + this.pattern + ", cronStyle=" + this.cronStyle + ", zone=" + this.zoneId;
    }

    public String getPattern() {
        return this.pattern;
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    @Override
    public boolean isDisabled() {
        return DISABLED.equals(this.pattern);
    }

    private static class DisabledScheduleExecutionTime
    implements ExecutionTime {
        private DisabledScheduleExecutionTime() {
        }

        @Override
        public Optional<ZonedDateTime> nextExecution(ZonedDateTime date) {
            throw this.unsupportedException();
        }

        @Override
        public Optional<Duration> timeToNextExecution(ZonedDateTime date) {
            throw this.unsupportedException();
        }

        @Override
        public Optional<ZonedDateTime> lastExecution(ZonedDateTime date) {
            throw this.unsupportedException();
        }

        @Override
        public Optional<Duration> timeFromLastExecution(ZonedDateTime date) {
            throw this.unsupportedException();
        }

        @Override
        public boolean isMatch(ZonedDateTime date) {
            throw this.unsupportedException();
        }

        private UnsupportedOperationException unsupportedException() {
            return new UnsupportedOperationException("Schedule is marked as disabled. Method should never be called");
        }
    }
}

