/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface SchedulerName {
    public String getName();

    public static class Hostname
    implements SchedulerName {
        private static final Logger LOG = LoggerFactory.getLogger(Hostname.class);
        private String cachedHostname;

        public Hostname() {
            try {
                long start = System.currentTimeMillis();
                LOG.debug("Resolving hostname..");
                this.cachedHostname = InetAddress.getLocalHost().getHostName();
                LOG.debug("Resolved hostname..");
                long duration = System.currentTimeMillis() - start;
                if (duration > 1000L) {
                    LOG.warn("Hostname-lookup took {}ms", (Object)duration);
                }
            }
            catch (UnknownHostException e) {
                LOG.warn("Failed to resolve hostname. Using dummy-name for scheduler.");
                this.cachedHostname = "failed.hostname.lookup";
            }
        }

        @Override
        public String getName() {
            return this.cachedHostname;
        }
    }

    public static class Fixed
    implements SchedulerName {
        private final String name;

        public Fixed(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

