/*
 * Copyright (C) Gustav Karlsson
 *
 * <p>Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of the License at
 *
 * <p>http://www.apache.org/licenses/LICENSE-2.0
 *
 * <p>Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.github.kagkarlsson.scheduler;

import com.github.kagkarlsson.scheduler.event.SchedulerListener;
import com.github.kagkarlsson.scheduler.event.SchedulerListener.SchedulerEventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RunAndLogErrors implements Runnable {
  private static final Logger LOG = LoggerFactory.getLogger(RunAndLogErrors.class);
  private final Runnable toRun;
  private final SchedulerListener schedulerListener;

  public RunAndLogErrors(Runnable toRun, SchedulerListener schedulerListener) {
    this.toRun = toRun;
    this.schedulerListener = schedulerListener;
  }

  @Override
  public void run() {
    try {
      toRun.run();
    } catch (Throwable e) {
      LOG.error("Unhandled exception. Will keep running.", e);
      schedulerListener.onSchedulerEvent(SchedulerEventType.UNEXPECTED_ERROR);
    }
  }
}
