/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler;

import com.github.kagkarlsson.scheduler.Clock;
import com.github.kagkarlsson.scheduler.CurrentlyExecuting;
import com.github.kagkarlsson.scheduler.ExecutorUtils;
import com.github.kagkarlsson.scheduler.task.Execution;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Executor {
    private static final Logger LOG = LoggerFactory.getLogger(Executor.class);
    final Map<UUID, CurrentlyExecuting> currentlyProcessing = Collections.synchronizedMap(new HashMap());
    private AtomicInteger currentlyInQueueOrProcessing = new AtomicInteger(0);
    private final ExecutorService executorService;
    private final Clock clock;

    public Executor(ExecutorService executorService, Clock clock) {
        this.executorService = executorService;
        this.clock = clock;
    }

    public void addToQueue(Runnable r, Runnable afterDone) {
        this.currentlyInQueueOrProcessing.incrementAndGet();
        this.executorService.execute(() -> {
            try {
                r.run();
            }
            finally {
                this.currentlyInQueueOrProcessing.decrementAndGet();
                afterDone.run();
            }
        });
    }

    public List<CurrentlyExecuting> getCurrentlyExecuting() {
        return new ArrayList<CurrentlyExecuting>(this.currentlyProcessing.values());
    }

    public void stop(Duration shutdownMaxWait) {
        LOG.info("Letting running executions finish. Will wait up to 2x{}.", (Object)shutdownMaxWait);
        Instant startShutdown = this.clock.now();
        if (ExecutorUtils.shutdownAndAwaitTermination(this.executorService, shutdownMaxWait, shutdownMaxWait)) {
            LOG.info("Scheduler stopped.");
        } else {
            LOG.warn("Scheduler stopped, but some tasks did not complete. Was currently running the following executions:\n{}", (Object)new ArrayList<CurrentlyExecuting>(this.currentlyProcessing.values()).stream().map(CurrentlyExecuting::getExecution).map(Execution::toString).collect(Collectors.joining("\n")));
        }
        Duration shutdownTime = Duration.between(startShutdown, this.clock.now());
        if (shutdownMaxWait.toMillis() > Duration.ofMinutes(1L).toMillis() && shutdownTime.toMillis() >= shutdownMaxWait.toMillis()) {
            LOG.info("Shutdown of the scheduler executor service took {}. Consider regularly checking for 'executionContext.getSchedulerState().isShuttingDown()' in task execution-handler and abort when scheduler is shutting down.", (Object)shutdownTime);
        }
    }

    public int getNumberInQueueOrProcessing() {
        return this.currentlyInQueueOrProcessing.get();
    }

    public UUID addCurrentlyProcessing(CurrentlyExecuting currentlyExecuting) {
        UUID executionId = UUID.randomUUID();
        this.currentlyProcessing.put(executionId, currentlyExecuting);
        return executionId;
    }

    public void removeCurrentlyProcessing(UUID executionId) {
        if (this.currentlyProcessing.remove(executionId) == null) {
            LOG.warn("Released execution was not found in collection of executions currently being processed. Should never happen. Execution-id: " + String.valueOf(executionId));
        }
    }
}

