/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.exceptions;

import com.github.kagkarlsson.scheduler.exceptions.DbSchedulerException;

public class TaskInstanceException
extends DbSchedulerException {
    private static final long serialVersionUID = -2132850112553296791L;
    private static final String TASK_NAME_INSTANCE_MESSAGE_PART = " (task name: %s, instance id: %s)";
    private final String taskName;
    private final String instanceId;

    public TaskInstanceException(String message, String taskName, String instanceId, Throwable ex) {
        super(message + String.format(TASK_NAME_INSTANCE_MESSAGE_PART, taskName, instanceId), ex);
        this.taskName = taskName;
        this.instanceId = instanceId;
    }

    public TaskInstanceException(String message, String taskName, String instanceId) {
        super(message + String.format(TASK_NAME_INSTANCE_MESSAGE_PART, taskName, instanceId));
        this.taskName = taskName;
        this.instanceId = instanceId;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getInstanceId() {
        return this.instanceId;
    }
}

