/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.jdbc;

import com.github.kagkarlsson.jdbc.IntegrityConstraintViolation;
import com.github.kagkarlsson.jdbc.PreparedStatementSetter;
import com.github.kagkarlsson.jdbc.ResultSetMapper;
import com.github.kagkarlsson.jdbc.RowMapper;
import com.github.kagkarlsson.jdbc.SQLRuntimeException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcRunner {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcRunner.class);
    private final DataSource dataSource;

    public JdbcRunner(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public int execute(String query, PreparedStatementSetter setParameters) {
        return this.execute(query, setParameters, p -> p.getUpdateCount());
    }

    public <T> List<T> query(String query, PreparedStatementSetter setParameters, RowMapper<T> rowMapper) {
        return this.execute(query, setParameters, p -> this.mapResultSet(p, rowMapper));
    }

    public <T> T query(String query, PreparedStatementSetter setParameters, ResultSetMapper<T> resultSetMapper) {
        return (T)this.execute(query, setParameters, p -> this.mapResultSet(p, resultSetMapper));
    }

    private <T> T execute(String query, PreparedStatementSetter setParameters, AfterExecution<T> afterExecution) {
        return (T)this.withConnection(c -> {
            PreparedStatement preparedStatement = null;
            try {
                try {
                    preparedStatement = c.prepareStatement(query);
                }
                catch (SQLException e) {
                    throw new SQLRuntimeException("Error when preparing statement.", e);
                }
                try {
                    LOG.trace("Setting parameters of prepared statement.");
                    setParameters.setParameters(preparedStatement);
                }
                catch (SQLException e) {
                    throw new SQLRuntimeException(e);
                }
                try {
                    LOG.trace("Executing prepared statement");
                    preparedStatement.execute();
                    Object e = afterExecution.doAfterExecution(preparedStatement);
                    return e;
                }
                catch (SQLException e) {
                    throw this.translateException(e);
                }
            }
            finally {
                this.nonThrowingClose(preparedStatement);
            }
        });
    }

    private SQLRuntimeException translateException(SQLException ex) {
        if (ex instanceof SQLIntegrityConstraintViolationException) {
            return new IntegrityConstraintViolation(ex);
        }
        return new SQLRuntimeException(ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withConnection(Function<Connection, T> doWithConnection) {
        Connection c;
        try {
            LOG.trace("Getting connection from datasource");
            c = this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new SQLRuntimeException("Unable to open connection", e);
        }
        try {
            T t = doWithConnection.apply(c);
            return t;
        }
        finally {
            this.nonThrowingClose(c);
        }
    }

    private <T> List<T> mapResultSet(PreparedStatement executedPreparedStatement, RowMapper<T> rowMapper) {
        return this.withResultSet(executedPreparedStatement, rs -> {
            ArrayList results = new ArrayList();
            while (rs.next()) {
                results.add(rowMapper.map(rs));
            }
            return results;
        });
    }

    private <T> T mapResultSet(PreparedStatement executedPreparedStatement, ResultSetMapper<T> resultSetMapper) {
        return (T)this.withResultSet(executedPreparedStatement, rs -> resultSetMapper.map(rs));
    }

    private <T> T withResultSet(PreparedStatement executedPreparedStatement, DoWithResultSet<T> doWithResultSet) {
        ResultSet rs = null;
        try {
            try {
                rs = executedPreparedStatement.getResultSet();
            }
            catch (SQLException e) {
                throw new SQLRuntimeException(e);
            }
            try {
                T e = doWithResultSet.withResultSet(rs);
            }
            catch (SQLException e) {
                throw new SQLRuntimeException(e);
            }
            return e;
        }
        finally {
            this.nonThrowingClose(rs);
        }
    }

    private void nonThrowingClose(AutoCloseable toClose) {
        if (toClose == null) {
            return;
        }
        try {
            LOG.trace("Closing " + toClose.getClass().getSimpleName());
            toClose.close();
        }
        catch (Exception e) {
            LOG.warn("Exception on close of " + toClose.getClass().getSimpleName(), (Throwable)e);
        }
    }

    static interface DoWithResultSet<T> {
        public T withResultSet(ResultSet var1) throws SQLException;
    }

    static interface AfterExecution<T> {
        public T doAfterExecution(PreparedStatement var1) throws SQLException;
    }
}

