/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.jdbc;

import com.github.kagkarlsson.jdbc.SQLRuntimeException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionManager {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionManager.class);
    ThreadLocal<Connection> currentTransaction = new ThreadLocal();
    private final DataSource dataSource;

    public TransactionManager(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public <T> T inTransaction(DoInTransaction<T> doInTransaction) {
        if (this.currentTransaction.get() != null) {
            throw new SQLRuntimeException("Cannot start new transaction when there already is an ongoing transaction.");
        }
        boolean restoreAutocommit = false;
        try {
            T t;
            block16: {
                Connection connection = this.dataSource.getConnection();
                try {
                    T result;
                    if (connection.getAutoCommit()) {
                        connection.setAutoCommit(false);
                        restoreAutocommit = true;
                    }
                    try {
                        this.currentTransaction.set(connection);
                        result = doInTransaction.doInTransaction();
                    }
                    catch (SQLRuntimeException applicationException) {
                        this.rollback(connection, applicationException);
                        throw applicationException;
                    }
                    this.commit(connection);
                    if (restoreAutocommit) {
                        this.restoreAutocommit(connection);
                    }
                    t = result;
                    if (connection == null) break block16;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException openCloseException) {
                        throw new SQLRuntimeException(openCloseException);
                    }
                }
                connection.close();
            }
            return t;
        }
        finally {
            this.currentTransaction.remove();
        }
    }

    private void restoreAutocommit(Connection connection) {
        try {
            connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException("Exception when restoring autocommit on connection. Transaction is already committed, but connection might be broken afterwards.", e);
        }
    }

    private void commit(Connection connection) {
        try {
            connection.commit();
        }
        catch (SQLException commitException) {
            this.rollback(connection, commitException);
        }
    }

    private void rollback(Connection connection, Throwable originalException) {
        try {
            connection.rollback();
        }
        catch (SQLException rollbackException) {
            LOG.error("Original application exception overridden by rollback-exception. Throwing rollback-exception. Original application exception: ", originalException);
            throw new SQLRuntimeException(rollbackException);
        }
        catch (RuntimeException rollbackException) {
            LOG.error("Original application exception overridden by rollback-exception. Throwing rollback-exception. Original application exception: ", originalException);
            throw rollbackException;
        }
    }

    public static interface DoInTransaction<T> {
        public T doInTransaction();
    }
}

