/*
 * Decompiled with CFR 0.152.
 */
package com.github.kaklakariada.fritzbox;

import com.github.kaklakariada.fritzbox.Config;
import com.github.kaklakariada.fritzbox.EnergyStatisticsService;
import com.github.kaklakariada.fritzbox.FritzBoxSession;
import com.github.kaklakariada.fritzbox.http.QueryParameters;
import com.github.kaklakariada.fritzbox.model.homeautomation.Device;
import com.github.kaklakariada.fritzbox.model.homeautomation.DeviceList;
import com.github.kaklakariada.fritzbox.model.homeautomation.DeviceStats;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HomeAutomation {
    private static final Logger LOG = LoggerFactory.getLogger(HomeAutomation.class);
    private static final String HOME_AUTOMATION_PATH = "/webservices/homeautoswitch.lua";
    private final FritzBoxSession session;

    private HomeAutomation(FritzBoxSession fritzbox) {
        this.session = fritzbox;
    }

    public static HomeAutomation connect(Config config) {
        return HomeAutomation.connect(config.getUrl(), config.getUsername(), config.getPassword());
    }

    public static HomeAutomation connect(String baseUrl, String username, String password) {
        LOG.info("Logging in to '{}' with username '{}'", (Object)baseUrl, (Object)username);
        FritzBoxSession session = new FritzBoxSession(baseUrl);
        session.login(username, password);
        return new HomeAutomation(session);
    }

    public DeviceList getDeviceListInfos() {
        DeviceList deviceList = this.executeCommand("getdevicelistinfos", DeviceList.class);
        LOG.trace("Found {} devices, devicelist version: {}", (Object)deviceList.getDevices().size(), (Object)deviceList.getApiVersion());
        return deviceList;
    }

    public Device getDeviceInfos(String deviceAin) {
        return this.executeDeviceCommand(deviceAin, "getdeviceinfos", Param.PARAM, null, Device.class);
    }

    private <T> T executeCommand(String command, Class<T> resultType) {
        QueryParameters parameters = QueryParameters.builder().add("switchcmd", command).build();
        return this.session.getAutenticated(HOME_AUTOMATION_PATH, parameters, resultType);
    }

    private <T> T executeParamCommand(String deviceAin, String command, String parameter, Class<T> responseType) {
        return this.executeDeviceCommand(deviceAin, command, Param.PARAM, parameter, responseType);
    }

    private <T> T executeLevelCommand(String deviceAin, String command, String parameter, Class<T> responseType) {
        return this.executeDeviceCommand(deviceAin, command, Param.LEVEL, parameter, responseType);
    }

    private <T> T executeTargetCommand(String deviceAin, String command, String parameter, Class<T> responseType) {
        return this.executeDeviceCommand(deviceAin, command, Param.TARGET, parameter, responseType);
    }

    private <T> T executeDeviceCommand(String deviceAin, String command, Param paramName, String parameter, Class<T> responseType) {
        QueryParameters.Builder paramBuilder = QueryParameters.builder().add("ain", deviceAin).add("switchcmd", command);
        if (parameter != null) {
            paramBuilder.add(paramName.name, parameter);
        }
        return this.session.getAutenticated(HOME_AUTOMATION_PATH, paramBuilder.build(), responseType);
    }

    public List<String> getSwitchList() {
        String switches = this.executeCommand("getswitchlist", String.class);
        List<String> idList = Arrays.asList(switches.split(","));
        LOG.trace("Got switch list string '{}': {}", (Object)switches, idList);
        return idList;
    }

    public void switchPowerState(String deviceAin, boolean on) {
        String command = on ? "setswitchon" : "setswitchoff";
        this.executeParamCommand(deviceAin, command, null, Boolean.class);
    }

    public void togglePowerState(String deviceAin) {
        this.executeParamCommand(deviceAin, "setswitchtoggle", null, Boolean.class);
    }

    public void setHkrTsoll(String deviceAin, String tsoll) {
        this.executeParamCommand(deviceAin, "sethkrtsoll", tsoll, Boolean.class);
    }

    public void setBlind(String deviceAin, String target) {
        this.executeTargetCommand(deviceAin, "setblind", target, Boolean.class);
    }

    public void setLevel(String deviceAin, String level) {
        this.executeLevelCommand(deviceAin, "setlevel", level, Boolean.class);
    }

    public void setLevelPercentage(String deviceAin, String level) {
        this.executeLevelCommand(deviceAin, "setlevelpercentage", level, Boolean.class);
    }

    public boolean getSwitchState(String deviceAin) {
        return this.executeParamCommand(deviceAin, "getswitchstate", null, Boolean.class);
    }

    public boolean getSwitchPresent(String deviceAin) {
        return this.executeParamCommand(deviceAin, "getswitchpresent", null, Boolean.class);
    }

    public String getSwitchName(String deviceAin) {
        return this.executeParamCommand(deviceAin, "getswitchname", null, String.class);
    }

    public Float getTemperature(String deviceAin) {
        Integer centiDegree = this.executeParamCommand(deviceAin, "gettemperature", null, Integer.class);
        return centiDegree == null ? null : Float.valueOf((float)centiDegree.intValue() / 10.0f);
    }

    public DeviceStats getBasicStatistics(String deviceAin) {
        return this.executeParamCommand(deviceAin, "getbasicdevicestats", null, DeviceStats.class);
    }

    public Float getSwitchPowerWatt(String deviceAin) {
        Integer powerMilliWatt = this.executeParamCommand(deviceAin, "getswitchpower", null, Integer.class);
        return powerMilliWatt == null ? null : Float.valueOf((float)powerMilliWatt.intValue() / 1000.0f);
    }

    public Integer getSwitchEnergyWattHour(String deviceAin) {
        return this.executeParamCommand(deviceAin, "getswitchenergy", null, Integer.class);
    }

    public EnergyStatisticsService getEnergyStatistics() {
        return new EnergyStatisticsService(this.session);
    }

    public void logout() {
        this.session.logout();
    }

    private static enum Param {
        PARAM("param"),
        LEVEL("level"),
        TARGET("target");

        private final String name;

        private Param(String name) {
            this.name = name;
        }
    }
}

