/*
 * Decompiled with CFR 0.152.
 */
package com.github.kaklakariada.fritzbox;

import com.github.kaklakariada.fritzbox.AbstractTestHelper;
import com.github.kaklakariada.fritzbox.Config;
import com.github.kaklakariada.fritzbox.HomeAutomation;
import com.github.kaklakariada.fritzbox.model.homeautomation.Device;
import com.github.kaklakariada.fritzbox.model.homeautomation.DeviceList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestBlind
extends AbstractTestHelper {
    private static final Logger LOG = LoggerFactory.getLogger(TestBlind.class);
    private static final int WAIT_SECONDS = 20;
    private final HomeAutomation homeAutomation = HomeAutomation.connect(Config.read());

    public TestBlind() throws InterruptedException {
        List<Device> blindDevices = this.getBlindDevices();
        if (blindDevices.isEmpty()) {
            LOG.warn("No blind devices found");
            return;
        }
        int wasPercenClosed = blindDevices.get(0).getLevelControl().getLevelpercentage();
        this.toggleBlindOpenClose();
        this.togglePercentOpen();
        this.setPercentOpen(blindDevices.get(0), wasPercenClosed);
    }

    private void toggleBlindOpenClose() throws InterruptedException {
        LOG.info("");
        LOG.info("Initial setting");
        List<Device> blindDevices = this.getBlindDevices();
        if (blindDevices.isEmpty()) {
            return;
        }
        this.showStatus(blindDevices);
        this.toggleBlindOpenClose(blindDevices.get(0));
        this.sleep();
        LOG.info("");
        LOG.info("Status after change");
        blindDevices = this.getBlindDevices();
        this.showStatus(blindDevices);
        this.toggleBlindOpenClose(blindDevices.get(0));
        LOG.info("");
        this.sleep();
        blindDevices = this.getBlindDevices();
        this.showStatus(blindDevices);
    }

    private void sleep() throws InterruptedException {
        LOG.info("Wait {} seconds", (Object)20);
        Thread.sleep(20000L);
    }

    private void toggleBlindOpenClose(Device blind) {
        String ain = this.getAin(blind.getIdentifier());
        boolean wasOpen = blind.getLevelControl().getLevel() == 0;
        String newStatus = wasOpen ? "close" : "open";
        LOG.info("");
        LOG.info("Changing status of blind {} (ain='{}') to {}", new Object[]{blind.getName(), ain, newStatus});
        this.homeAutomation.setBlind(ain, newStatus);
    }

    private void togglePercentOpen() throws InterruptedException {
        LOG.info("");
        LOG.info("Initial setting");
        List<Device> blindDevices = this.getBlindDevices();
        if (blindDevices.isEmpty()) {
            return;
        }
        this.showStatus(blindDevices);
        int wasPercenClosed = blindDevices.get(0).getLevelControl().getLevelpercentage();
        int newPercenClosed = wasPercenClosed == 0 ? 50 : wasPercenClosed / 2;
        this.setPercentOpen(blindDevices.get(0), newPercenClosed);
        this.sleep();
        LOG.info("");
        LOG.info("Status after change");
        blindDevices = this.getBlindDevices();
        this.showStatus(blindDevices);
        this.setPercentOpen(blindDevices.get(0), wasPercenClosed);
        LOG.info("");
        this.sleep();
        blindDevices = this.getBlindDevices();
        this.showStatus(blindDevices);
    }

    private void setPercentOpen(Device blind, int percent) {
        String ain = this.getAin(blind.getIdentifier());
        String newLevel = String.valueOf(percent);
        LOG.info("");
        LOG.info("Changing status of blind {} (ain='{}') to {}", new Object[]{blind.getName(), ain, newLevel});
        this.homeAutomation.setLevelPercentage(ain, newLevel);
    }

    private List<Device> getBlindDevices() {
        DeviceList devices = this.homeAutomation.getDeviceListInfos();
        return devices.getDevices().stream().filter(device -> device.getBlind() != null).collect(Collectors.toList());
    }

    private void showStatus(List<Device> blindDevices) {
        blindDevices.forEach(blind -> {
            String message = String.format("%-15s Mode: %s Percent-Closed: %s%%", blind.getName(), blind.getBlind().getMode(), blind.getLevelControl().getLevelpercentage());
            LOG.info(message);
        });
    }

    public static void main(String[] args) throws InterruptedException {
        new TestBlind();
    }
}

