/*
 * Decompiled with CFR 0.152.
 */
package com.github.kaklakariada.fritzbox.login;

import com.github.kaklakariada.fritzbox.login.ChallengeResponse;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

class Pbkdf2ChallengeResponse
implements ChallengeResponse {
    Pbkdf2ChallengeResponse() {
    }

    @Override
    public String calculateResponse(String challenge, String password) {
        String[] challengeParts = challenge.split("\\$");
        if (challengeParts.length != 5) {
            throw new IllegalArgumentException("Challenge '" + challenge + "' has an invalid format");
        }
        int iter1 = Integer.parseInt(challengeParts[1]);
        byte[] salt1 = Pbkdf2ChallengeResponse.fromHex(challengeParts[2]);
        int iter2 = Integer.parseInt(challengeParts[3]);
        byte[] salt2 = Pbkdf2ChallengeResponse.fromHex(challengeParts[4]);
        byte[] hash1 = Pbkdf2ChallengeResponse.pbkdf2HmacSha256(password.getBytes(StandardCharsets.UTF_8), salt1, iter1);
        byte[] hash2 = Pbkdf2ChallengeResponse.pbkdf2HmacSha256(hash1, salt2, iter2);
        return challengeParts[4] + "$" + Pbkdf2ChallengeResponse.toHex(hash2);
    }

    static byte[] fromHex(String hexString) {
        int len = hexString.length() / 2;
        byte[] ret = new byte[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = (byte)Short.parseShort(hexString.substring(i * 2, i * 2 + 2), 16);
        }
        return ret;
    }

    static String toHex(byte[] bytes) {
        StringBuilder s = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            s.append(String.format("%02x", b));
        }
        return s.toString();
    }

    static byte[] pbkdf2HmacSha256(byte[] password, byte[] salt, int iters) {
        String algorithm = "HmacSHA256";
        try {
            Mac sha256mac = Mac.getInstance("HmacSHA256");
            sha256mac.init(new SecretKeySpec(password, "HmacSHA256"));
            byte[] ret = new byte[sha256mac.getMacLength()];
            byte[] tmp = new byte[salt.length + 4];
            System.arraycopy(salt, 0, tmp, 0, salt.length);
            tmp[salt.length + 3] = 1;
            for (int i = 0; i < iters; ++i) {
                tmp = sha256mac.doFinal(tmp);
                for (int k = 0; k < ret.length; ++k) {
                    int n = k;
                    ret[n] = (byte)(ret[n] ^ tmp[k]);
                }
            }
            return ret;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IllegalStateException("Failed to calculate HMAC", e);
        }
    }
}

