/*
 * Decompiled with CFR 0.152.
 */
package com.github.kaklakariada.fritzbox.mapping;

import com.github.kaklakariada.fritzbox.mapping.DeserializerException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import org.simpleframework.xml.Serializer;
import org.simpleframework.xml.core.Persister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Deserializer {
    private static final Logger LOG = LoggerFactory.getLogger(Deserializer.class);
    private final Serializer xmlSerializer;

    public Deserializer() {
        this((Serializer)new Persister());
    }

    Deserializer(Serializer xmlSerializer) {
        this.xmlSerializer = xmlSerializer;
    }

    public <T> T parse(InputStream data, Class<T> resultType) {
        try {
            Object resultObject = resultType == String.class || resultType == Boolean.class || resultType == Integer.class ? this.parseSimpleType(resultType, data) : this.xmlSerializer.read(resultType, data);
            LOG.trace("Parsed response: {}", resultObject);
            return resultObject;
        }
        catch (Exception e) {
            throw new DeserializerException("Error parsing response body", e);
        }
    }

    private <T> T parseSimpleType(Class<T> resultType, InputStream data) throws IOException {
        String string = this.getStringFromStream(data);
        if (resultType == String.class) {
            return resultType.cast(string);
        }
        if (resultType == Boolean.class) {
            return resultType.cast("1".equals(string));
        }
        if (resultType == Integer.class) {
            if (string.isEmpty() || "inval".equals(string)) {
                return null;
            }
            return resultType.cast(Integer.parseInt(string));
        }
        throw new IOException("Type '" + resultType + "' is not supported: " + string);
    }

    public String getStringFromStream(InputStream data) {
        Scanner scanner = new Scanner(data, StandardCharsets.UTF_8.toString());
        String string = scanner.next();
        scanner.close();
        return string;
    }
}

