/*
 * Decompiled with CFR 0.152.
 */
package com.github.kaklakariada.fritzbox.model.homeautomation;

import com.github.kaklakariada.fritzbox.MissingClassException;
import com.github.kaklakariada.fritzbox.model.homeautomation.Energy;
import com.github.kaklakariada.fritzbox.model.homeautomation.Humidity;
import com.github.kaklakariada.fritzbox.model.homeautomation.Power;
import com.github.kaklakariada.fritzbox.model.homeautomation.Temperature;
import com.github.kaklakariada.fritzbox.model.homeautomation.Voltage;

public enum MeasurementUnit {
    TEMPERATURE("C", 0.1, Temperature.class),
    VOLTAGE("V", 0.001, Voltage.class),
    POWER("W", 0.01, Power.class),
    ENERGY("Wh", 1, Energy.class),
    HUMIDITY("%", 1, Humidity.class);

    private final String unit;
    private final Number precision;
    private final Class<?> mapper;

    private MeasurementUnit(String unit, Number precision, Class<?> mapper) {
        this.unit = unit;
        this.precision = precision;
        this.mapper = mapper;
    }

    public String getUnit() {
        return this.unit;
    }

    public Number getPrescision() {
        return this.precision;
    }

    public Class<?> getMapper() {
        return this.mapper;
    }

    public static MeasurementUnit getMatchingMeasurementUnit(Class<?> caller) {
        for (MeasurementUnit iterator : MeasurementUnit.values()) {
            if (!caller.isAssignableFrom(iterator.getMapper())) continue;
            return iterator;
        }
        throw new MissingClassException(String.format("Could not detect enum of type 'MeasurementUnit' associated to class '%s'", caller.toString()));
    }
}

