/*
 * Decompiled with CFR 0.152.
 */
package testlink.api.java.client;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import testlink.api.java.client.TestLinkAPIConst;
import testlink.api.java.client.TestLinkAPIException;
import testlink.api.java.client.TestLinkAPIHelper;
import testlink.api.java.client.TestLinkAPIResults;

public class TestLinkAPIClient
implements TestLinkAPIConst {
    public boolean isConnected = false;
    public String connectErrorMsg = "";
    boolean useCache = false;
    Map cacheList = new HashMap();
    public String DEV_KEY;
    public String SERVER_URL;

    public TestLinkAPIClient(String devKey, String url) {
        this.DEV_KEY = devKey;
        this.SERVER_URL = url;
        this.check();
    }

    public TestLinkAPIClient(String devKey, String url, boolean useCache) {
        this.DEV_KEY = devKey;
        this.SERVER_URL = url;
        this.useCache = useCache;
        this.check();
    }

    private void check() {
        try {
            this.about();
            this.isConnected = true;
        }
        catch (Exception e) {
            this.isConnected = false;
            this.connectErrorMsg = e.getMessage();
        }
    }

    public TestLinkAPIResults about() throws TestLinkAPIException {
        Hashtable params = new Hashtable();
        this.setParam(params, true, "devKey", this.DEV_KEY);
        return this.execXmlRpcMethodWithCache("tl.about", params, null);
    }

    public TestLinkAPIResults ping() throws TestLinkAPIException {
        Hashtable params = new Hashtable();
        this.setParam(params, true, "devKey", this.DEV_KEY);
        return this.execXmlRpcMethodWithCache("tl.ping", params, null);
    }

    public TestLinkAPIResults reportTestCaseResult(String projectName, String testPlanName, String testCaseNameOrVisibleID, String buildName, String execNotes, String testResultStatus) throws TestLinkAPIException {
        Integer projectID = TestLinkAPIHelper.getProjectID(this, projectName);
        if (projectID == null) {
            throw new TestLinkAPIException("The project " + projectName + " was not found and the test case " + testCaseNameOrVisibleID + " could not be accessed to report a test result.");
        }
        Integer planID = TestLinkAPIHelper.getPlanID(this, projectID, testPlanName);
        if (planID == null) {
            throw new TestLinkAPIException("The plan " + testPlanName + " was not found and the test case " + testCaseNameOrVisibleID + " could not be accessed to report a test result.");
        }
        Integer caseID = TestLinkAPIHelper.getTestCaseID(this, projectID, testCaseNameOrVisibleID);
        if (caseID == null) {
            throw new TestLinkAPIException("The test case identifier " + caseID + " was not found and the test case " + testCaseNameOrVisibleID + " could not be accessed to report a test result to test plan " + testPlanName + ".");
        }
        Integer buildID = null;
        if (buildName != null && (buildID = TestLinkAPIHelper.getBuildID(this, planID, buildName)) == null) {
            throw new TestLinkAPIException("The build name " + buildName + " was not found in test plan " + testPlanName + " and the test result for test case " + testCaseNameOrVisibleID + " could not be recorded.");
        }
        TestLinkAPIResults results = this.reportTestCaseResult(planID, caseID, buildID, execNotes, testResultStatus);
        return results;
    }

    public TestLinkAPIResults reportTestCaseResult(Integer testPlanID, Integer testCaseID, Integer buildID, String execNotes, String testResultStatus) throws TestLinkAPIException {
        Boolean guess = new Boolean(true);
        if (buildID != null) {
            guess = new Boolean(false);
        }
        TestLinkAPIResults results = this.reportTestCaseResult(testPlanID, testCaseID, buildID, null, guess, execNotes, testResultStatus);
        return results;
    }

    public TestLinkAPIResults reportTestCaseResult(String projectName, String testPlanName, String testCaseNameOrVisibleID, String buildName, String execNotes, String testResultStatus, String bugID) throws TestLinkAPIException {
        Integer projectID = TestLinkAPIHelper.getProjectID(this, projectName);
        if (projectID == null) {
            throw new TestLinkAPIException("The project " + projectName + " was not found and the test case " + testCaseNameOrVisibleID + " could not be accessed to report a test result.");
        }
        Integer planID = TestLinkAPIHelper.getPlanID(this, projectID, testPlanName);
        if (planID == null) {
            throw new TestLinkAPIException("The plan " + testPlanName + " was not found and the test case " + testCaseNameOrVisibleID + " could not be accessed to report a test result.");
        }
        Integer caseID = TestLinkAPIHelper.getTestCaseID(this, projectID, testCaseNameOrVisibleID);
        if (caseID == null) {
            throw new TestLinkAPIException("The test case identifier " + caseID + " was not found and the test case " + testCaseNameOrVisibleID + " could not be accessed to report a test result to test plan " + testPlanName + ".");
        }
        Integer buildID = null;
        if (buildName != null && (buildID = TestLinkAPIHelper.getBuildID(this, planID, buildName)) == null) {
            throw new TestLinkAPIException("The build name " + buildName + " was not found in test plan " + testPlanName + " and the test result for test case " + testCaseNameOrVisibleID + " could not be recorded.");
        }
        TestLinkAPIResults results = this.reportTestCaseResult(planID, caseID, buildID, execNotes, testResultStatus, bugID);
        return results;
    }

    public TestLinkAPIResults reportTestCaseResult(Integer testPlanID, Integer testCaseID, Integer buildID, String execNotes, String testResultStatus, String bugID) throws TestLinkAPIException {
        Boolean guess = new Boolean(true);
        if (buildID != null) {
            guess = new Boolean(false);
        }
        TestLinkAPIResults results = this.reportTestCaseResult(testPlanID, testCaseID, buildID, bugID, guess, execNotes, testResultStatus);
        return results;
    }

    public TestLinkAPIResults reportTestCaseResult(Integer testPlanID, Integer testCaseID, Integer buildID, String bugID, Boolean guess, String execNotes, String testResultStatus) throws TestLinkAPIException {
        Hashtable params = new Hashtable();
        this.setParam(params, true, "devKey", this.DEV_KEY);
        this.setParam(params, true, "testplanid", testPlanID);
        this.setParam(params, true, "testcaseid", testCaseID);
        this.setParam(params, false, "buildid", buildID);
        this.setParam(params, false, "bugid", bugID);
        this.setParam(params, false, "guess", guess);
        this.setParam(params, false, "notes", execNotes);
        this.setParam(params, true, "status", testResultStatus);
        return this.execXmlRpcMethodWithCache("tl.reportTCResult", params, null);
    }

    public Integer createTestProject(String projectName, String testCasePrefix, String description) throws TestLinkAPIException {
        this.initCache();
        Hashtable params = new Hashtable();
        this.setParam(params, true, "devKey", this.DEV_KEY);
        this.setParam(params, true, "testprojectname", projectName);
        this.setParam(params, true, "testcaseprefix", testCasePrefix);
        this.setParam(params, true, "notes", description);
        TestLinkAPIResults results = this.executeXmlRpcMethod("tl.createTestProject", params);
        return this.getCreatedRecordIdentifier(results, "id");
    }

    public Integer createTestSuite(String projectName, String suiteName, String description) throws TestLinkAPIException {
        Integer projectID = TestLinkAPIHelper.getProjectID(this, projectName);
        if (projectID != null) {
            return this.createTestSuite(projectID, suiteName, description);
        }
        throw new TestLinkAPIException("The project " + projectName + " was not found and the test suite " + suiteName + " could not be created.");
    }

    public Integer createTestSuite(Integer projectID, String suiteName, String description) throws TestLinkAPIException {
        return this.createTestSuite(projectID, suiteName, description, null, null, null);
    }

    public Integer createTestSuite(Integer projectID, String suiteName, String description, Integer parentID, Integer order, Boolean check) throws TestLinkAPIException {
        this.initCache();
        Hashtable params = new Hashtable();
        this.setParam(params, true, "devKey", this.DEV_KEY);
        this.setParam(params, true, "testprojectid", projectID.toString());
        this.setParam(params, true, "testsuitename", suiteName);
        this.setParam(params, true, "details", description);
        this.setParam(params, false, "parentid", parentID);
        this.setParam(params, false, "order", order);
        this.setParam(params, false, "checkduplicatedname", check);
        TestLinkAPIResults results = this.executeXmlRpcMethod("tl.createTestSuite", params);
        return this.getCreatedRecordIdentifier(results, "id");
    }

    public Integer createTestCase(String authorLoginName, String projectName, String suiteName, String testCaseName, String summary, String steps, String expectedResults, String importance) throws TestLinkAPIException {
        Integer projectID = TestLinkAPIHelper.getProjectID(this, projectName);
        Integer suiteID = TestLinkAPIHelper.getSuiteID(this, projectName, suiteName);
        return this.createTestCase(authorLoginName, projectID, suiteID, testCaseName, summary, steps, expectedResults, null, null, null, null, null, importance);
    }

    public Integer createTestCase(String authorLoginName, Integer projectID, Integer suiteID, String caseName, String summary, String steps, String expectedResults, Integer order, Integer internalID, Boolean checkDuplicatedName, String actionOnDuplicatedName, String executionType, String importance) throws TestLinkAPIException {
        this.initCache();
        Hashtable params = new Hashtable();
        this.setParam(params, true, "devKey", this.DEV_KEY);
        this.setParam(params, true, "authorlogin", authorLoginName);
        this.setParam(params, true, "testprojectid", projectID);
        this.setParam(params, true, "testsuiteid", suiteID);
        this.setParam(params, true, "testcasename", caseName);
        this.setParam(params, true, "summary", summary);
        this.setParam(params, true, "steps", steps);
        this.setParam(params, true, "expectedresults", expectedResults);
        this.setParam(params, false, "order", order);
        this.setParam(params, false, "internalid", internalID);
        this.setParam(params, false, "checkduplicatedname", checkDuplicatedName);
        this.setParam(params, false, "actiononduplicatedname", actionOnDuplicatedName);
        this.setParam(params, false, "executiontype", executionType);
        this.setParam(params, false, "importance", importance);
        this.executeXmlRpcMethod("tl.createTestCase", params);
        return TestLinkAPIHelper.getCaseIDByName(this, projectID, suiteID, caseName);
    }

    public Integer createBuild(String projectName, String planName, String buildName, String buildNotes) throws TestLinkAPIException {
        Integer projectID = TestLinkAPIHelper.getProjectID(this, projectName);
        if (projectID == null) {
            throw new TestLinkAPIException("The project " + projectName + " was not found and the build " + buildName + " could not be created.");
        }
        Integer planID = TestLinkAPIHelper.getPlanID(this, projectID, planName);
        if (planID != null) {
            return this.createBuild(planID, buildName, buildNotes);
        }
        throw new TestLinkAPIException("The plan " + planName + " was not found and the build " + buildName + " could not be created.");
    }

    public Integer createBuild(Integer planID, String buildName, String buildNotes) throws TestLinkAPIException {
        this.initCache();
        Hashtable params = new Hashtable();
        this.setParam(params, true, "devKey", this.DEV_KEY);
        this.setParam(params, true, "testplanid", planID);
        this.setParam(params, true, "buildname", buildName);
        this.setParam(params, true, "buildnotes", buildNotes);
        TestLinkAPIResults results = this.executeXmlRpcMethod("tl.createBuild", params);
        return this.getCreatedRecordIdentifier(results, "id");
    }

    public TestLinkAPIResults addTestCaseToTestPlan(String projectName, String planName, String testCaseName) throws TestLinkAPIException {
        int maxNode = 0;
        TestLinkAPIResults cases = this.getCasesForTestPlan(projectName, planName);
        int i = 0;
        while (i < cases.size()) {
            Map data = cases.getData(i);
            Object node = data.get("execution_order");
            if (node != null) {
                try {
                    Integer cn = new Integer(node.toString());
                    if (cn > maxNode) {
                        maxNode = cn;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
        TestLinkAPIResults results = this.addTestCaseToTestPlan(projectName, planName, testCaseName, new Integer(++maxNode), null);
        return results;
    }

    public TestLinkAPIResults addTestCaseToTestPlan(String projectName, String planName, String testCaseName, Integer execOrder, String urgency) throws TestLinkAPIException {
        Integer projectID = TestLinkAPIHelper.getProjectID(this, projectName);
        if (projectID == null) {
            throw new TestLinkAPIException("The project " + projectName + " was not found and the test case " + testCaseName + " could not be appended.");
        }
        Integer planID = TestLinkAPIHelper.getPlanID(this, projectID, planName);
        if (planID == null) {
            throw new TestLinkAPIException("The plan " + planName + " was not found and the test case " + testCaseName + " could not be appended.");
        }
        Integer caseID = TestLinkAPIHelper.getCaseIDByName(this, projectID, testCaseName);
        if (caseID == null) {
            throw new TestLinkAPIException("The test case " + testCaseName + " was not found and the test case" + " could not be appended to test plan " + planName + ".");
        }
        Map caseInfo = TestLinkAPIHelper.getTestCaseInfo(this, projectID, caseID);
        if (caseInfo == null) {
            throw new TestLinkAPIException("The test case identifier " + caseID + " was not found and the test case " + testCaseName + " could not be appended to test plan " + planName + ".");
        }
        Map projectInfo = TestLinkAPIHelper.getProjectInfo(this, projectName);
        if (projectInfo == null) {
            throw new TestLinkAPIException("The project information for " + projectName + " was not found and the test case " + testCaseName + " could not be appended to test plan " + planName + ".");
        }
        Object prefix = projectInfo.get("prefix");
        Object externalID = caseInfo.get("tc_external_id");
        String visibleTestCaseID = String.valueOf(String.valueOf(prefix.toString())) + '-' + externalID.toString();
        Object version = caseInfo.get("version");
        TestLinkAPIResults results = this.addTestCaseToTestPlan(projectID, planID, visibleTestCaseID, new Integer(version.toString()), execOrder, urgency);
        return results;
    }

    public TestLinkAPIResults addTestCaseToTestPlan(Integer projectID, Integer planID, String testCaseVisibleID, Integer version, Integer execOrder, String urgency) throws TestLinkAPIException {
        this.initCache();
        Hashtable params = new Hashtable();
        this.setParam(params, true, "devKey", this.DEV_KEY);
        this.setParam(params, true, "testprojectid", projectID);
        this.setParam(params, true, "testplanid", planID);
        this.setParam(params, true, "testcaseexternalid", testCaseVisibleID);
        this.setParam(params, true, "version", version);
        this.setParam(params, false, "urgency", urgency);
        this.setParam(params, false, "executionorder", execOrder);
        TestLinkAPIResults results = this.executeXmlRpcMethod("tl.addTestCaseToTestPlan", params);
        if (results.size() < 1) {
            throw new TestLinkAPIException("Could not add test case " + testCaseVisibleID + " to test plan id " + planID);
        }
        Map data = results.getData(0);
        if (this.hasError(data)) {
            throw new TestLinkAPIException("Could not add test case " + testCaseVisibleID + " to test plan id " + planID + ". Results Message: [" + data.toString() + "]");
        }
        return results;
    }

    public TestLinkAPIResults getProjects() throws TestLinkAPIException {
        Hashtable params = new Hashtable();
        this.setParam(params, true, "devKey", this.DEV_KEY);
        return this.execXmlRpcMethodWithCache("tl.getProjects", params, "projects");
    }

    public TestLinkAPIResults getProjectTestPlans(String projectName) throws TestLinkAPIException {
        Integer projectID = TestLinkAPIHelper.getProjectID(this, projectName);
        return this.getProjectTestPlans(projectID);
    }

    public TestLinkAPIResults getProjectTestPlans(Integer projectID) throws TestLinkAPIException {
        Hashtable params = new Hashtable();
        this.setParam(params, true, "devKey", this.DEV_KEY);
        this.setParam(params, true, "testprojectid", projectID);
        return this.execXmlRpcMethodWithCache("tl.getProjectTestPlans", params, projectID);
    }

    public TestLinkAPIResults getBuildsForTestPlan(String projectName, String planName) throws TestLinkAPIException {
        Integer projectID = TestLinkAPIHelper.getProjectID(this, projectName);
        if (projectID == null) {
            throw new TestLinkAPIException("The project " + projectName + " was not found.");
        }
        Integer planID = TestLinkAPIHelper.getPlanID(this, projectID, planName);
        if (planID == null) {
            throw new TestLinkAPIException("The plan " + planName + " was not found.");
        }
        return this.getBuildsForTestPlan(planID);
    }

    public TestLinkAPIResults getBuildsForTestPlan(Integer planID) throws TestLinkAPIException {
        Hashtable params = new Hashtable();
        this.setParam(params, true, "devKey", this.DEV_KEY);
        this.setParam(params, true, "testplanid", planID);
        return this.execXmlRpcMethodWithCache("tl.getBuildsForTestPlan", params, planID);
    }

    public TestLinkAPIResults getLatestBuildForTestPlan(String projectName, String planName) throws TestLinkAPIException {
        Integer projectID = TestLinkAPIHelper.getProjectID(this, projectName);
        if (projectID == null) {
            throw new TestLinkAPIException("The project " + projectName + " was not found.");
        }
        Integer planID = TestLinkAPIHelper.getPlanID(this, projectID, planName);
        if (planID == null) {
            throw new TestLinkAPIException("The plan " + planName + " was not found.");
        }
        return this.getLatestBuildForTestPlan(planID);
    }

    public TestLinkAPIResults getLatestBuildForTestPlan(Integer planID) throws TestLinkAPIException {
        Hashtable params = new Hashtable();
        this.setParam(params, true, "devKey", this.DEV_KEY);
        this.setParam(params, true, "testplanid", planID);
        return this.execXmlRpcMethodWithCache("tl.getLatestBuildForTestPlan", params, planID);
    }

    public TestLinkAPIResults getFirstLevelTestSuitesForTestProject(String projectName) throws TestLinkAPIException {
        Integer projectID = TestLinkAPIHelper.getProjectID(this, projectName);
        return this.getFirstLevelTestSuitesForTestProject(projectID);
    }

    public TestLinkAPIResults getFirstLevelTestSuitesForTestProject(Integer projectID) throws TestLinkAPIException {
        Hashtable params = new Hashtable();
        this.setParam(params, true, "devKey", this.DEV_KEY);
        this.setParam(params, true, "testprojectid", projectID);
        return this.execXmlRpcMethodWithCache("tl.getFirstLevelTestSuitesForTestProject", params, projectID);
    }

    public TestLinkAPIResults getTestCaseIDByName(String testCaseName) throws TestLinkAPIException {
        return this.getTestCaseIDByName(testCaseName, null, null);
    }

    public TestLinkAPIResults getTestCaseIDByName(String testCaseName, String testProjectName, String testSuiteName) throws TestLinkAPIException {
        Hashtable params = new Hashtable();
        this.setParam(params, true, "devKey", this.DEV_KEY);
        this.setParam(params, true, "testcasename", testCaseName);
        this.setParam(params, false, "testprojectname", testProjectName);
        this.setParam(params, false, "testsuitename", testSuiteName);
        return this.execXmlRpcMethodWithCache("tl.getTestCaseIDByName", params, null);
    }

    public TestLinkAPIResults getCasesForTestSuite(Integer testProjectID, Integer testSuiteID) throws TestLinkAPIException {
        String key = String.valueOf(String.valueOf(testProjectID.toString())) + "-" + testSuiteID.toString();
        Hashtable params = new Hashtable();
        this.setParam(params, true, "devKey", this.DEV_KEY);
        this.setParam(params, true, "testprojectid", testProjectID);
        this.setParam(params, true, "testsuiteid", testSuiteID);
        this.setParam(params, true, "deep", new Boolean(true));
        this.setParam(params, true, "details", "full");
        return this.execXmlRpcMethodWithCache("tl.getTestCasesForTestSuite", params, key);
    }

    public TestLinkAPIResults getTestSuitesForTestPlan(String projectName, String planName) throws TestLinkAPIException {
        Integer projectID = TestLinkAPIHelper.getProjectID(this, projectName);
        if (projectID == null) {
            throw new TestLinkAPIException("Could not get project identifier for " + projectName);
        }
        Integer planID = TestLinkAPIHelper.getPlanID(this, projectID, planName);
        if (planID == null) {
            throw new TestLinkAPIException("Could not get plan identifier for " + planName);
        }
        return this.getTestSuitesForTestPlan(planID);
    }

    public TestLinkAPIResults getTestSuitesForTestPlan(Integer testPlanID) throws TestLinkAPIException {
        Hashtable params = new Hashtable();
        this.setParam(params, true, "devKey", this.DEV_KEY);
        this.setParam(params, true, "testplanid", testPlanID);
        return this.execXmlRpcMethodWithCache("tl.getTestSuitesForTestPlan", params, testPlanID);
    }

    public TestLinkAPIResults getLastExecutionResult(String projectName, String testPlanName, String testCaseNameOrVisibleID) throws TestLinkAPIException {
        Integer projectID = TestLinkAPIHelper.getProjectID(this, projectName);
        if (projectID == null) {
            throw new TestLinkAPIException("The project " + projectName + " was not found.");
        }
        Integer planID = TestLinkAPIHelper.getPlanID(this, projectID, testPlanName);
        if (planID == null) {
            throw new TestLinkAPIException("The plan " + testPlanName + " was not found.");
        }
        Integer caseID = TestLinkAPIHelper.getTestCaseID(this, projectID, testCaseNameOrVisibleID);
        if (caseID == null) {
            throw new TestLinkAPIException("The test case " + testCaseNameOrVisibleID + " was not found and the test case" + " could not be accessed to report a test result against plan " + testPlanName + ".");
        }
        return this.getLastExecutionResult(planID, caseID);
    }

    public TestLinkAPIResults getLastExecutionResult(Integer testPlanID, Integer testCaseID) throws TestLinkAPIException {
        Hashtable params = new Hashtable();
        this.setParam(params, true, "devKey", this.DEV_KEY);
        this.setParam(params, true, "testplanid", testPlanID);
        this.setParam(params, true, "testcaseid", testCaseID);
        return this.execXmlRpcMethodWithCache("tl.getLastExecutionResult", params, testPlanID);
    }

    public TestLinkAPIResults getCasesForTestPlan(String projectName, String planName) throws TestLinkAPIException {
        Integer projectID = TestLinkAPIHelper.getProjectID(this, projectName);
        if (projectID == null) {
            throw new TestLinkAPIException("Could not get project identifier for " + projectName);
        }
        Integer planID = TestLinkAPIHelper.getPlanID(this, projectID, planName);
        if (planID == null) {
            throw new TestLinkAPIException("Could not get plan identifier for " + planName);
        }
        return this.getCasesForTestPlan(planID);
    }

    public TestLinkAPIResults getCasesForTestPlan(Integer testPlanID) throws TestLinkAPIException {
        return this.getCasesForTestPlan(testPlanID, null, null, null, null, null, null, null);
    }

    public TestLinkAPIResults getCasesForTestPlan(Integer testPlanID, Integer testCaseID, Integer buildID, Integer keywordID, String executed, String assignedTo, String execStatus, String execType) throws TestLinkAPIException {
        String key = "Plan:" + testPlanID.toString();
        key = String.valueOf(String.valueOf(key)) + "Case:";
        if (testCaseID != null) {
            key = String.valueOf(String.valueOf(key)) + testCaseID.toString();
        }
        key = String.valueOf(String.valueOf(key)) + "Build:";
        if (buildID != null) {
            key = String.valueOf(String.valueOf(key)) + buildID.toString();
        }
        key = String.valueOf(String.valueOf(key)) + "KW:";
        if (keywordID != null) {
            key = String.valueOf(String.valueOf(key)) + keywordID.toString();
        }
        key = String.valueOf(String.valueOf(key)) + "Exec:";
        if (executed != null) {
            key = String.valueOf(String.valueOf(key)) + executed;
        }
        key = String.valueOf(String.valueOf(key)) + "Assign:";
        if (assignedTo != null) {
            key = String.valueOf(String.valueOf(key)) + assignedTo;
        }
        key = String.valueOf(String.valueOf(key)) + "ES:";
        if (execStatus != null) {
            key = String.valueOf(String.valueOf(key)) + execStatus;
        }
        key = String.valueOf(String.valueOf(key)) + "ET:";
        if (execType != null) {
            key = String.valueOf(String.valueOf(key)) + execType;
        }
        Hashtable params = new Hashtable();
        this.setParam(params, true, "devKey", this.DEV_KEY);
        this.setParam(params, true, "testplanid", testPlanID);
        this.setParam(params, false, "testcaseid", testCaseID);
        this.setParam(params, false, "buildid", buildID);
        this.setParam(params, false, "keywordid", keywordID);
        this.setParam(params, false, "executed", executed);
        this.setParam(params, false, "assignedto", assignedTo);
        this.setParam(params, false, "executestatus", execStatus);
        this.setParam(params, false, "executiontype", execType);
        return this.execXmlRpcMethodWithCache("tl.getTestCasesForTestPlan", params, key);
    }

    private void initCache() {
        this.cacheList = new HashMap();
    }

    private TestLinkAPIResults execXmlRpcMethodWithCache(String method, Hashtable params, Object cacheKey) throws TestLinkAPIException {
        boolean isCached = true;
        if (method == null) {
            throw new TestLinkAPIException("A method must be provided for caching a xml-rpc calls to work.");
        }
        HashMap<Object, TestLinkAPIResults> cache = (HashMap<Object, TestLinkAPIResults>)this.cacheList.get(method);
        if (cache == null || !this.useCache || cacheKey == null) {
            cache = new HashMap<Object, TestLinkAPIResults>();
            this.cacheList.put(method, cache);
            isCached = false;
        } else if (!cache.containsKey(cacheKey)) {
            isCached = false;
        }
        TestLinkAPIResults results = null;
        if (!isCached) {
            results = this.executeXmlRpcMethod(method, params);
            if (cacheKey != null) {
                cache.put(cacheKey, results);
            }
        } else {
            results = (TestLinkAPIResults)cache.get(cacheKey);
        }
        if (results == null) {
            throw new TestLinkAPIException("\nThe xml-rpc call to TestLink API method " + method + " failed because the results were null.");
        }
        if (this.hasError(results)) {
            throw new TestLinkAPIException("\nThe xml-rpc call to TestLink API method " + method + " failed.\n" + results);
        }
        return results;
    }

    private TestLinkAPIResults executeXmlRpcMethod(String method, Hashtable executionData) throws TestLinkAPIException {
        TestLinkAPIResults results = new TestLinkAPIResults();
        ArrayList<Hashtable> params = new ArrayList<Hashtable>();
        XmlRpcClient rpcClient = this.getRpcClient();
        int unknownResultTypeCnt = 0;
        try {
            params.add(executionData);
            Object[] rawResults = (Object[])rpcClient.execute(method, params);
            int i = 0;
            while (i < rawResults.length) {
                Map result = (Map)rawResults[i];
                if (result instanceof Map) {
                    Map item = result;
                    results.add(item);
                } else {
                    HashMap<String, Map> data = new HashMap<String, Map>();
                    data.put(TestLinkAPIClient.getUnknownKey(++unknownResultTypeCnt), result);
                    results.add(data);
                }
                ++i;
            }
        }
        catch (Exception e) {
            try {
                Object single = rpcClient.execute(method, params);
                if (single instanceof Map) {
                    results.add((Map)single);
                } else if (single != null && single.toString().length() > 0) {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put(TestLinkAPIClient.getUnknownKey(++unknownResultTypeCnt), single);
                    results.add(data);
                }
            }
            catch (Exception ee) {
                throw new TestLinkAPIException("The call to the xml-rpc client failed.", e);
            }
        }
        return results;
    }

    private static String getUnknownKey(int cnt) {
        String key = new Integer(cnt).toString();
        return "RESULT_" + key;
    }

    private XmlRpcClient getRpcClient() throws TestLinkAPIException {
        XmlRpcClient rpcClient = null;
        try {
            XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
            config.setServerURL(new URL(this.SERVER_URL));
            rpcClient = new XmlRpcClient();
            rpcClient.setConfig((XmlRpcClientConfig)config);
        }
        catch (Exception e) {
            throw new TestLinkAPIException("Unable to create a XML-RPC client.", e);
        }
        return rpcClient;
    }

    private void setParam(Hashtable params, boolean isRequired, String paramName, Object value) throws TestLinkAPIException {
        if (isRequired && value == null) {
            throw new TestLinkAPIException("The required parameter " + paramName + " was not provided by the caller.");
        }
        if (!isRequired && value == null) {
            return;
        }
        try {
            Integer intTypeValue = new Integer(value.toString());
            params.put(paramName, intTypeValue);
        }
        catch (Exception e) {
            params.put(paramName, value.toString());
        }
    }

    private Integer getCreatedRecordIdentifier(TestLinkAPIResults results, String idKey) throws TestLinkAPIException {
        Integer newID = null;
        if (results.size() == 1) {
            Object id = results.getValueByName(0, idKey);
            if (id != null) {
                newID = new Integer(id.toString());
            } else {
                Map msg = results.getData(0);
                String failMsg = "Create failed since the identifier for new record was not retrieved.\nAPI Returned Data: [" + msg.toString() + "]";
                throw new TestLinkAPIException(failMsg);
            }
        }
        return newID;
    }

    private boolean hasError(TestLinkAPIResults results) {
        if (results == null) {
            return true;
        }
        if (results.size() > 0) {
            return this.hasError(results.getData(0));
        }
        return false;
    }

    private boolean hasError(Map data) {
        String message = (String)data.get("message");
        Object code = data.get("code");
        return message != null && code != null && !message.toLowerCase().contains("success");
    }
}

