/*
 * Decompiled with CFR 0.152.
 */
package testlink.api.java.client;

import java.util.ArrayList;
import java.util.Map;
import testlink.api.java.client.TestLinkAPIClient;
import testlink.api.java.client.TestLinkAPIConst;
import testlink.api.java.client.TestLinkAPIException;
import testlink.api.java.client.TestLinkAPIResults;

public class TestLinkAPIHelper
implements TestLinkAPIConst {
    public static Integer getProjectID(TestLinkAPIClient apiClient, String projectName) throws TestLinkAPIException {
        Map data = TestLinkAPIHelper.getProjectInfo(apiClient, projectName);
        return TestLinkAPIHelper.getIdentifier(data);
    }

    public static Map getProjectInfo(TestLinkAPIClient apiClient, String projectName) throws TestLinkAPIException {
        TestLinkAPIResults results = apiClient.getProjects();
        int i = 0;
        while (i < results.size()) {
            Object data = results.getValueByName(i, "name");
            if (data != null && projectName.equals(data.toString())) {
                return results.getData(i);
            }
            ++i;
        }
        return null;
    }

    public static Map getProjectInfo(TestLinkAPIClient apiClient, Integer projectID) throws TestLinkAPIException {
        TestLinkAPIResults results = apiClient.getProjects();
        int i = 0;
        while (i < results.size()) {
            Integer identifier;
            Object data = results.getValueByName(i, "id");
            if (data != null && projectID.compareTo(identifier = new Integer(data.toString())) == 0) {
                return results.getData(i);
            }
            ++i;
        }
        return null;
    }

    public static Integer getSuiteID(TestLinkAPIClient apiClient, String projectName, String suiteName) throws TestLinkAPIException {
        Integer projectID = TestLinkAPIHelper.getProjectID(apiClient, projectName);
        return TestLinkAPIHelper.getSuiteID(apiClient, projectID, suiteName);
    }

    public static Map getSuiteInfo(TestLinkAPIClient apiClient, String projectName, String suiteName) throws TestLinkAPIException {
        Integer projectID = TestLinkAPIHelper.getProjectID(apiClient, projectName);
        return TestLinkAPIHelper.getSuiteInfo(apiClient, projectID, suiteName);
    }

    public static Integer getSuiteID(TestLinkAPIClient apiClient, Integer projectID, String suiteName) throws TestLinkAPIException {
        Map data = TestLinkAPIHelper.getSuiteInfo(apiClient, projectID, suiteName);
        return TestLinkAPIHelper.getIdentifier(data);
    }

    public static Map getSuiteInfo(TestLinkAPIClient apiClient, Integer projectID, String suiteName) throws TestLinkAPIException {
        TestLinkAPIResults results = apiClient.getFirstLevelTestSuitesForTestProject(projectID);
        int i = 0;
        while (i < results.size()) {
            Object data = results.getValueByName(i, "name");
            if (data != null && suiteName.equals(data.toString())) {
                return results.getData(i);
            }
            ++i;
        }
        return null;
    }

    public static String getCaseVisibleID(TestLinkAPIClient apiClient, String projectName, String caseName) throws TestLinkAPIException {
        Map projectInfo = TestLinkAPIHelper.getProjectInfo(apiClient, projectName);
        Integer projectID = TestLinkAPIHelper.getIdentifier(projectInfo);
        Integer caseID = TestLinkAPIHelper.getCaseIDByName(apiClient, projectID, caseName);
        Map caseInfo = TestLinkAPIHelper.getTestCaseInfo(apiClient, projectID, caseID);
        Object prefix = projectInfo.get("prefix");
        Object externalID = caseInfo.get("tc_external_id");
        return String.valueOf(String.valueOf(prefix.toString())) + '-' + externalID.toString();
    }

    public static Integer getTestCaseID(TestLinkAPIClient apiClient, Integer projectID, String testCaseNameOrVisibleID) throws TestLinkAPIException {
        Integer caseID = null;
        try {
            caseID = TestLinkAPIHelper.getCaseIDByName(apiClient, projectID, testCaseNameOrVisibleID);
        }
        catch (Exception e) {
            caseID = null;
        }
        if (caseID == null) {
            try {
                caseID = TestLinkAPIHelper.getCaseIDByVisibleID(apiClient, projectID, testCaseNameOrVisibleID);
            }
            catch (Exception ee) {
                return null;
            }
        }
        return caseID;
    }

    public static Integer getCaseIDByName(TestLinkAPIClient apiClient, Integer projectID, String caseName) throws TestLinkAPIException {
        ArrayList cases = new ArrayList();
        TestLinkAPIResults results = apiClient.getFirstLevelTestSuitesForTestProject(projectID);
        int i = 0;
        while (i < results.size()) {
            Object id = results.getValueByName(i, "id");
            if (id != null) {
                TestLinkAPIHelper.addAllMatchingCases(apiClient, cases, projectID, new Integer(id.toString()), caseName, null, false);
            }
            ++i;
        }
        Map data = TestLinkAPIHelper.getLatestVersionCaseID(cases);
        return TestLinkAPIHelper.getIdentifier(data);
    }

    public static Integer getCaseIDByName(TestLinkAPIClient apiClient, Integer projectID, Integer suiteID, String caseName) throws TestLinkAPIException {
        ArrayList cases = new ArrayList();
        TestLinkAPIHelper.addAllMatchingCases(apiClient, cases, projectID, suiteID, caseName, null, false);
        Map data = TestLinkAPIHelper.getLatestVersionCaseID(cases);
        return TestLinkAPIHelper.getIdentifier(data);
    }

    public static Integer getCaseIDByVisibleID(TestLinkAPIClient apiClient, Integer projectID, String caseName) throws TestLinkAPIException {
        ArrayList cases = new ArrayList();
        Map projectInfo = TestLinkAPIHelper.getProjectInfo(apiClient, projectID);
        if (projectInfo == null) {
            throw new TestLinkAPIException("The failed to get the project information.");
        }
        String prefix = (String)projectInfo.get("prefix");
        TestLinkAPIResults results = apiClient.getFirstLevelTestSuitesForTestProject(projectID);
        int i = 0;
        while (i < results.size()) {
            Object id = results.getValueByName(i, "id");
            if (id != null) {
                TestLinkAPIHelper.addAllMatchingCases(apiClient, cases, projectID, new Integer(id.toString()), caseName, prefix, true);
            }
            ++i;
        }
        Map data = TestLinkAPIHelper.getLatestVersionCaseID(cases);
        return TestLinkAPIHelper.getIdentifier(data);
    }

    private static void addAllMatchingCases(TestLinkAPIClient apiClient, ArrayList cases, Integer projectID, Integer suiteID, String casePattern, String prefix, boolean useVisibleID) throws TestLinkAPIException {
        TestLinkAPIResults results = apiClient.getCasesForTestSuite(projectID, suiteID);
        Object id = null;
        int i = 0;
        while (i < results.size()) {
            Map data = results.getData(i);
            if (data != null) {
                Object externalID = data.get("tc_external_id");
                Object name = data.get("name");
                if (externalID != null && name != null) {
                    String currentPattern = name.toString();
                    if (useVisibleID) {
                        currentPattern = String.valueOf(String.valueOf(prefix.toString())) + '-' + externalID.toString();
                    }
                    if (casePattern.equalsIgnoreCase(currentPattern) && (id = results.getValueByName(i, "id")) != null) {
                        cases.add(results.getData(i));
                    }
                }
            }
            ++i;
        }
    }

    public static Map getTestCaseInfo(TestLinkAPIClient apiClient, Integer projectID, Integer testCaseID) throws TestLinkAPIException {
        TestLinkAPIResults suites = apiClient.getFirstLevelTestSuitesForTestProject(projectID);
        int i = 0;
        while (i < suites.size()) {
            Object id = suites.getValueByName(i, "id");
            if (id != null) {
                Integer suiteID = new Integer(id.toString());
                TestLinkAPIResults cases = apiClient.getCasesForTestSuite(projectID, suiteID);
                int c = 0;
                while (c < cases.size()) {
                    id = cases.getValueByName(c, "id");
                    Integer currentTestCase = new Integer(id.toString());
                    if (currentTestCase.compareTo(testCaseID) == 0) {
                        return cases.getData(c);
                    }
                    ++c;
                }
            }
            ++i;
        }
        return null;
    }

    private static Map getLatestVersionCaseID(ArrayList cases) {
        int cv;
        Object version;
        Map data;
        int maxVersion = 0;
        int i = 0;
        while (i < cases.size()) {
            data = (Map)cases.get(i);
            version = data.get("tcversion_id");
            if (version != null && (cv = new Integer(version.toString()).intValue()) > maxVersion) {
                maxVersion = cv;
            }
            ++i;
        }
        i = 0;
        while (i < cases.size()) {
            data = (Map)cases.get(i);
            version = data.get("tcversion_id");
            if (version != null && (cv = new Integer(version.toString()).intValue()) == maxVersion) {
                return data;
            }
            ++i;
        }
        return null;
    }

    public static Integer getPlanID(TestLinkAPIClient apiClient, Integer projectID, String planName) throws TestLinkAPIException {
        Object id = null;
        Integer planID = null;
        Map planInfo = TestLinkAPIHelper.getPlanInfo(apiClient, projectID, planName);
        if (planInfo != null) {
            Object v = planInfo.get("id");
            id = v;
            if (v != null) {
                planID = new Integer(id.toString());
            }
        }
        return planID;
    }

    public static Map getPlanInfo(TestLinkAPIClient apiClient, Integer projectID, String planName) throws TestLinkAPIException {
        TestLinkAPIResults results = apiClient.getProjectTestPlans(projectID);
        int i = 0;
        while (i < results.size()) {
            Object data = results.getValueByName(i, "name");
            if (data != null && planName.equals(data.toString())) {
                return results.getData(i);
            }
            ++i;
        }
        return null;
    }

    public static Integer getBuildID(TestLinkAPIClient apiClient, Integer planID, String buildName) throws TestLinkAPIException {
        Map data = TestLinkAPIHelper.getBuildInfo(apiClient, planID, buildName);
        return TestLinkAPIHelper.getIdentifier(data);
    }

    public static Map getBuildInfo(TestLinkAPIClient apiClient, Integer planID, String buildName) throws TestLinkAPIException {
        TestLinkAPIResults results = apiClient.getBuildsForTestPlan(planID);
        int i = 0;
        while (i < results.size()) {
            Object data = results.getValueByName(i, "name");
            if (data != null && buildName.equals(data.toString())) {
                return results.getData(i);
            }
            ++i;
        }
        return null;
    }

    private static Integer getIdentifier(Map data) {
        Integer identifier = null;
        Object id = null;
        if (data == null) {
            return identifier;
        }
        id = data.get("id");
        if (id != null) {
            identifier = new Integer(id.toString());
        }
        return identifier;
    }
}

