/*
 * Copyright 2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.github.kamikazbee;

public class RuleResponse {

    private final String message;

    RuleResponse(String message) {
        this.message = message;
    }

    String getMessage() {
        return message;
    }

    RuleResponse() {
        this.message = null;
    }

    boolean isSuccess() {
        return message == null;
    }

    /**
     * Create a success Response
     * @return Response that is success
     */
    public static RuleResponse success() {
        return new RuleResponse();
    }

    /**
     * Create a failure Response
     * @param message String with the failure message
     * @return Response that is failure
     */
    public static RuleResponse failure(String message) {
        return new RuleResponse(message);
    }

}
