/*
 * Decompiled with CFR 0.152.
 */
package com.github.kamikazbee;

import com.github.kamikazbee.RuleResponse;
import com.github.kamikazbee.Validation;
import com.github.kamikazbee.ValidationResult;
import com.github.kamikazbee.rules.Rule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class Validator<T> {
    private List<Validation> validations = new ArrayList<Validation>();

    public <R> Validator<T> addRule(Rule<R, ? extends Rule> r, Function<T, R> f, String field) {
        this.validations.add(new Validation(r, f, field));
        return this;
    }

    public <R> Validator<T> addRule(Rule<R, ? extends Rule> r, Function<T, R> f) {
        this.validations.add(new Validation(r, f));
        return this;
    }

    public <R> Validator<T> addNestedValidator(Validator<R> v, Function<T, R> f, String field) {
        this.validations.add(new Validation(v, f, field));
        return this;
    }

    public <R> Validator<T> addListValidator(Validator<R> v, Function<T, Collection<R>> f, String field) {
        this.validations.add(new Validation(v, f, field));
        return this;
    }

    public ValidationResult validate(T value) {
        ValidationResult result = new ValidationResult();
        for (Validation validation : this.validations) {
            Rule rule = validation.getRule();
            Function valueProvider = validation.getValueProvider();
            if (validation.isNested()) {
                this.validateNested(validation, value, result);
                continue;
            }
            RuleResponse response = rule.validate(valueProvider.apply(value));
            if (response.isSuccess()) continue;
            result.add(response, validation.getField());
            if (!validation.getRule().isBlocking()) continue;
            break;
        }
        return result;
    }

    private void validateNested(Validation validation, T value, ValidationResult result) {
        Object toBeValidated = validation.getValueProvider().apply(value);
        if (toBeValidated != null) {
            if (toBeValidated instanceof Collection) {
                Object[] x = ((Collection)toBeValidated).toArray();
                for (int i = 0; i < x.length; ++i) {
                    ValidationResult nestedResult = validation.getValidator().validate(x[i]);
                    if (nestedResult.isValid()) continue;
                    result.add(nestedResult, validation.getField() + "[" + i + "]");
                }
            } else {
                ValidationResult nestedResult = validation.getValidator().validate(toBeValidated);
                if (!nestedResult.isValid()) {
                    result.add(nestedResult, validation.getField());
                }
            }
        }
    }
}

