/*
 * Decompiled with CFR 0.152.
 */
package com.github.kamikazbee.rules;

import com.github.kamikazbee.rules.RuleImpl;
import java.util.function.Predicate;

public class LengthRule
extends RuleImpl<String, LengthRule> {
    private Number min;
    private Number max;
    private Number exact;

    public LengthRule min(Number min) {
        this.min = min;
        return this;
    }

    public LengthRule max(Number max) {
        this.max = max;
        return this;
    }

    public LengthRule exact(Number exact) {
        this.exact = exact;
        return this;
    }

    @Override
    protected String getMessage() {
        String superMessage = super.getMessage();
        if (superMessage != null) {
            return superMessage;
        }
        StringBuilder b = new StringBuilder();
        if (this.exact != null) {
            b.append("Must be exactly ").append(this.exact);
        } else if (this.min != null) {
            b.append("Cannot be less than ").append(this.min);
            if (this.max != null) {
                b.append(" or more than ").append(this.max);
            }
        } else if (this.max != null) {
            b.append("Cannot be more than ").append(this.max);
        }
        if (this.exact != null || this.min != null || this.max != null) {
            b.append(" characters long");
        }
        return b.toString();
    }

    @Override
    protected Predicate<String> getValidation() {
        return s -> {
            boolean valid = true;
            if (this.exact != null) {
                valid = (double)s.length() == this.exact.doubleValue();
            } else {
                if (this.min != null) {
                    boolean bl = valid = (double)s.length() >= this.min.doubleValue();
                }
                if (this.max != null) {
                    valid = valid && (double)s.length() <= this.max.doubleValue();
                }
            }
            return valid;
        };
    }
}

