/*
 * Decompiled with CFR 0.152.
 */
package com.github.kamikazbee.rules;

import com.github.kamikazbee.rules.RuleImpl;
import java.util.Objects;
import java.util.function.Predicate;

public class QuantityRule
extends RuleImpl<Number, QuantityRule> {
    private Number exact;
    private Number min;
    private Number max;

    public QuantityRule min(Number min) {
        this.min = min;
        return this;
    }

    public QuantityRule max(Number max) {
        this.max = max;
        return this;
    }

    public QuantityRule exact(Number exact) {
        this.exact = exact;
        return this;
    }

    @Override
    protected String getMessage() {
        String superMessage = super.getMessage();
        if (superMessage != null) {
            return superMessage;
        }
        StringBuilder b = new StringBuilder();
        if (this.exact != null || this.min != null || this.max != null) {
            b.append("Quantity");
        }
        if (this.exact != null) {
            b.append(" must be exactly ").append(this.exact);
        } else if (this.min != null) {
            b.append(" cannot be less than ").append(this.min);
            if (this.max != null) {
                b.append(" and more than ").append(this.max);
            }
        } else if (this.max != null) {
            b.append(" cannot be more than ").append(this.max);
        }
        return b.toString();
    }

    @Override
    protected Predicate<Number> getValidation() {
        return d -> {
            boolean valid = true;
            if (this.exact != null) {
                valid = Objects.equals(d, this.exact);
            } else {
                if (this.min != null) {
                    boolean bl = valid = d.doubleValue() >= this.min.doubleValue();
                }
                if (this.max != null) {
                    valid = valid && d.doubleValue() <= this.max.doubleValue();
                }
            }
            return valid;
        };
    }
}

