/*
 * Decompiled with CFR 0.152.
 */
package com.github.kamikazbee.rules;

import com.github.kamikazbee.RuleResponse;
import com.github.kamikazbee.rules.Rule;
import java.util.function.Predicate;

abstract class RuleImpl<T, R extends Rule>
implements Rule<T, R> {
    private String message;
    private Predicate<T> validation;
    private boolean blocking = false;
    private boolean optional = true;

    RuleImpl() {
    }

    @Override
    public R message(String message) {
        this.message = message;
        return (R)this;
    }

    protected R validation(Predicate<T> validation) {
        this.validation = validation;
        return (R)this;
    }

    @Override
    public R blocking(boolean blocking) {
        this.blocking = blocking;
        return (R)this;
    }

    @Override
    public R optional(boolean optional) {
        this.optional = optional;
        return (R)this;
    }

    @Override
    public RuleResponse validate(T value) {
        if (this.skipValidation(value) || this.getValidation().test(value)) {
            return RuleResponse.success();
        }
        return RuleResponse.failure(this.getMessage());
    }

    protected boolean skipValidation(T value) {
        return this.optional && value == null;
    }

    @Override
    public boolean isBlocking() {
        return this.blocking;
    }

    protected String getMessage() {
        return this.message;
    }

    protected Predicate<T> getValidation() {
        return this.validation;
    }
}

