/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.validationx.validator;

import com.github.kancyframework.validationx.validator.ValidationAware;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Assert;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Pointcut;
import org.springframework.aop.framework.autoproxy.AbstractBeanFactoryAwareAdvisingPostProcessor;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.expression.MapAccessor;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestParam;

public class AssertConstraintValidator
extends AbstractBeanFactoryAwareAdvisingPostProcessor
implements MethodInterceptor,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(AssertConstraintValidator.class);
    private final ExpressionParser parser = new SpelExpressionParser();
    private final ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
    private static final Map<Class, List<AssertMetaData>> ASSERT_META_DATA_MAP = new HashMap<Class, List<AssertMetaData>>();

    public Object invoke(MethodInvocation invocation) throws Throwable {
        int i;
        Object[] arguments = invocation.getArguments();
        if (Objects.isNull(arguments) || arguments.length == 0) {
            return invocation.proceed();
        }
        Method invocationMethod = invocation.getMethod();
        Parameter[] parameters = invocationMethod.getParameters();
        String[] parameterNames = this.parameterNameDiscoverer.getParameterNames(invocationMethod);
        HashMap<String, Object> rootMap = new HashMap<String, Object>(parameters.length);
        for (i = 0; i < parameters.length; ++i) {
            String parameterName;
            RequestParam annotation;
            if (Objects.nonNull(parameterNames)) {
                rootMap.put(parameterNames[i], arguments[i]);
            }
            if (!Objects.nonNull(annotation = parameters[i].getAnnotation(RequestParam.class)) || !StringUtils.hasText((String)(parameterName = annotation.name()))) continue;
            rootMap.put(parameterName, arguments[i]);
        }
        for (i = 0; i < arguments.length; ++i) {
            ArrayList<String> errors;
            ValidationAware validationAware;
            Object argument = arguments[i];
            Class<?> argumentClass = argument.getClass();
            if (List.class.isAssignableFrom(argumentClass) || argumentClass.isArray()) continue;
            if (ClassUtils.isPrimitiveOrWrapper(argumentClass) || Objects.equals(argumentClass, String.class)) {
                StandardEvaluationContext ctx = this.initStandardEvaluationContext();
                ctx.setRootObject(rootMap);
                ctx.addPropertyAccessor((PropertyAccessor)new MapAccessor());
                this.doCheckParameter(ctx, invocation.getMethod().getParameters()[i], parameterNames[i]);
                continue;
            }
            List<AssertMetaData> metaDataList = this.getAssertMetaDatas(argumentClass);
            if (!CollectionUtils.isEmpty(metaDataList)) {
                StandardEvaluationContext ctx = this.initStandardEvaluationContext();
                ctx.setRootObject(argument);
                for (AssertMetaData metaData : metaDataList) {
                    for (Assert annotation : metaData.getAsserts()) {
                        Expression exp = this.parser.parseExpression(annotation.value());
                        boolean result = Objects.equals(exp.getValue((EvaluationContext)ctx, Boolean.class), annotation.result());
                        if (result) continue;
                        String message = annotation.message();
                        if (StringUtils.isEmpty((Object)message)) {
                            message = String.format("\u53c2\u6570[%s]\u4e0d\u5408\u6cd5", metaData.getParamName());
                        }
                        throw new IllegalArgumentException(message);
                    }
                }
            }
            if (!(argument instanceof ValidationAware) || (validationAware = (ValidationAware)argument).validate(argument, errors = new ArrayList<String>()) || CollectionUtils.isEmpty(errors)) continue;
            throw new IllegalArgumentException((String)errors.get(0));
        }
        return invocation.proceed();
    }

    private StandardEvaluationContext initStandardEvaluationContext() {
        StandardEvaluationContext ctx = new StandardEvaluationContext();
        ReflectionUtils.doWithLocalMethods(SpelTools.class, method -> {
            ctx.registerFunction(method.getName(), method);
            ctx.registerFunction(method.getName().toLowerCase(), method);
            ctx.registerFunction(method.getName().toUpperCase(), method);
        });
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AssertMetaData> getAssertMetaDatas(Class<?> argumentClass) {
        List<AssertMetaData> assertMetaDataList = ASSERT_META_DATA_MAP.get(argumentClass);
        if (Objects.isNull(assertMetaDataList)) {
            Map<Class, List<AssertMetaData>> map = ASSERT_META_DATA_MAP;
            synchronized (map) {
                assertMetaDataList = ASSERT_META_DATA_MAP.get(argumentClass);
                if (Objects.isNull(assertMetaDataList)) {
                    assertMetaDataList = new ArrayList<AssertMetaData>();
                    this.findAssertMetaDataList(argumentClass, assertMetaDataList, false);
                }
                if (CollectionUtils.isEmpty(assertMetaDataList)) {
                    assertMetaDataList = Collections.emptyList();
                }
                ASSERT_META_DATA_MAP.put(argumentClass, assertMetaDataList);
            }
        }
        return assertMetaDataList;
    }

    private void findAssertMetaDataList(Class<?> argumentClass, List<AssertMetaData> metaDataList, boolean isRecursion) {
        Field[] fields;
        for (Field field : fields = argumentClass.getDeclaredFields()) {
            if (field.isAnnotationPresent(Assert.class) || field.isAnnotationPresent(Assert.List.class)) {
                AssertMetaData metaData = new AssertMetaData();
                metaData.setAsserts((Assert[])field.getAnnotationsByType(Assert.class));
                metaData.setParamName(field.getName());
                metaData.setValidObject(isRecursion);
                metaDataList.add(metaData);
            }
            if (!field.isAnnotationPresent(Valid.class) && !field.getType().isAnnotationPresent(Valid.class)) continue;
            this.findAssertMetaDataList(field.getType(), metaDataList, true);
        }
    }

    private void doCheckParameter(StandardEvaluationContext ctx, Parameter parameter, String parameterName) {
        for (Assert annotation : (Assert[])parameter.getAnnotationsByType(Assert.class)) {
            Expression exp = this.parser.parseExpression(annotation.value());
            boolean result = Objects.equals(exp.getValue((EvaluationContext)ctx, Boolean.class), annotation.result());
            if (result) continue;
            String message = annotation.message();
            if (StringUtils.isEmpty((Object)message)) {
                message = String.format("\u53c2\u6570[%s]\u4e0d\u5408\u6cd5", parameterName);
            }
            throw new IllegalArgumentException(message);
        }
    }

    public void afterPropertiesSet() {
        Class<?> annotationClass = this.getAnnotationClass();
        if (Objects.nonNull(annotationClass)) {
            AnnotationMatchingPointcut pointcut = new AnnotationMatchingPointcut(annotationClass, true);
            this.advisor = new DefaultPointcutAdvisor((Pointcut)pointcut, this.createMethodValidationAdvice());
        }
    }

    private Class<?> getAnnotationClass() {
        try {
            return ClassUtils.forName((String)"org.springframework.stereotype.Controller", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            log.debug(e.getMessage());
            return null;
        }
    }

    protected Advice createMethodValidationAdvice() {
        return this;
    }

    public static class SpelTools {
        public static boolean start(String object, Object sub) {
            return object.startsWith(String.valueOf(sub));
        }

        public static boolean end(String object, Object sub) {
            return object.endsWith(String.valueOf(sub));
        }

        public static boolean startsWith(String object, Object sub) {
            return object.startsWith(String.valueOf(sub));
        }

        public static boolean endsWith(String object, Object sub) {
            return object.endsWith(String.valueOf(sub));
        }

        public static boolean startWith(String object, Object sub) {
            return object.startsWith(String.valueOf(sub));
        }

        public static boolean endWith(String object, Object sub) {
            return object.endsWith(String.valueOf(sub));
        }

        public static boolean contains(String object, Object sub) {
            return object.contains(String.valueOf(sub));
        }

        public static boolean notContains(String object, Object sub) {
            return !SpelTools.contains(object, sub);
        }

        public static boolean in(Object object, Object list) {
            String value = String.valueOf(object);
            if (list instanceof Collection) {
                Collection collection = (Collection)list;
                return collection.stream().anyMatch(item -> Objects.equals(value, String.valueOf(item)));
            }
            if (list instanceof String) {
                String collection = (String)list;
                if (collection.contains(",")) {
                    return Arrays.asList(collection.split(",")).contains(value);
                }
                if (collection.contains("|")) {
                    return Arrays.asList(collection.split("[|]")).contains(value);
                }
                return Objects.equals(value, collection);
            }
            return true;
        }

        public static boolean notIn(Object object, Object list) {
            return !SpelTools.in(object, list);
        }

        public static boolean notNull(Object object) {
            return Objects.nonNull(object);
        }

        public static boolean notEmpty(Object object) {
            return StringUtils.hasLength((String)String.valueOf(object));
        }

        public static boolean notBlank(Object object) {
            return StringUtils.hasText((String)String.valueOf(object));
        }

        public static boolean range(Number object, Number start, Number end) {
            return object.doubleValue() >= start.doubleValue() && object.doubleValue() <= end.doubleValue();
        }

        public static boolean inRange(Number object, Number start, Number end) {
            return SpelTools.range(object, start, end);
        }

        public static boolean notRange(Number object, Number start, Number end) {
            return !SpelTools.range(object, start, end);
        }

        public static boolean notInRange(Number object, Number start, Number end) {
            return !SpelTools.range(object, start, end);
        }
    }

    public static class AssertMetaData {
        private boolean validObject;
        private String paramName;
        private Assert[] asserts;

        public String getParamName() {
            return this.paramName;
        }

        public void setParamName(String paramName) {
            this.paramName = paramName;
        }

        public Assert[] getAsserts() {
            return this.asserts;
        }

        public void setAsserts(Assert[] asserts) {
            this.asserts = asserts;
        }

        public boolean isValidObject() {
            return this.validObject;
        }

        public void setValidObject(boolean validObject) {
            this.validObject = validObject;
        }
    }
}

