/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.validationx.validator;

import com.github.kancyframework.validationx.validator.CheckEmptyConstraintValidator;
import java.text.SimpleDateFormat;
import javax.validation.constraints.DateCheck;

public class DateCheckConstraintValidator
extends CheckEmptyConstraintValidator<DateCheck, String> {
    @Override
    protected boolean check(String value) {
        String format = ((DateCheck)this.annotation).format();
        if (format.length() != value.length()) {
            return false;
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat(format);
            df.setLenient(false);
            df.parse(value);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    protected boolean requestEmptyResult() {
        return !((DateCheck)this.annotation).required();
    }
}

