/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.validationx.validator;

import com.github.kancyframework.validationx.config.ApplicationContextHolder;
import com.github.kancyframework.validationx.properties.EnumProperties;
import com.github.kancyframework.validationx.validator.CheckEmptyConstraintValidator;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.validation.ValidationException;
import javax.validation.constraints.EnumCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class EnumCheckConstraintValidator
extends CheckEmptyConstraintValidator<EnumCheck, Object> {
    private static Logger log = LoggerFactory.getLogger(EnumCheckConstraintValidator.class);
    private static Map<String, Boolean> enumCodeExistCache = new HashMap<String, Boolean>(64);
    private static Map<String, Method> enumMethodCache = new HashMap<String, Method>();

    @Override
    protected boolean check(Object value) {
        if (((EnumCheck)this.annotation).enumClass() != Empty.class) {
            return this.doValidByEnumClass(value);
        }
        if (((EnumCheck)this.annotation).enumCode().length > 0 || ((EnumCheck)this.annotation).enumCodeString().length() > 0) {
            return this.doValidByEnumCode(value);
        }
        return this.doValidBySpringConfig(value);
    }

    @Override
    protected boolean requestEmptyResult() {
        return !((EnumCheck)this.annotation).required();
    }

    private boolean doValidBySpringConfig(Object value) {
        Binder binder = Binder.get((Environment)ApplicationContextHolder.getContext().getEnvironment());
        String propertyKey = String.format("%s.%s", this.getConfigGroup(), this.getConfigName()).toLowerCase();
        BindResult bindResult = binder.bind(propertyKey, EnumProperties.class);
        Assert.isTrue((boolean)bindResult.isBound(), (String)String.format("EnumCheck missing configuration: not found (%s)", propertyKey));
        EnumProperties enumMeta = (EnumProperties)bindResult.get();
        if (!enumMeta.isEnabled()) {
            return true;
        }
        Assert.notEmpty(enumMeta.getItems(), (String)"EnumCheck missing configuration\uff1aenum items is empty");
        ArrayList list = new ArrayList();
        enumMeta.getItems().stream().forEach(item -> {
            Object itemValue = item.getValue();
            if (Objects.nonNull(itemValue)) {
                list.add(String.valueOf(itemValue));
            }
        });
        boolean isValid = list.contains(String.valueOf(value));
        return ((EnumCheck)this.annotation).reverse() ? !isValid : isValid;
    }

    private boolean doValidByEnumCode(Object value) {
        List<String> enumCodes = Arrays.asList(((EnumCheck)this.annotation).enumCode());
        if (enumCodes.isEmpty()) {
            enumCodes = Arrays.asList(StringUtils.split((String)((EnumCheck)this.annotation).enumCodeString(), (String)","));
        }
        boolean isValid = enumCodes.contains(String.valueOf(value));
        return ((EnumCheck)this.annotation).reverse() ? !isValid : isValid;
    }

    private boolean doValidByEnumClass(Object value) {
        if (((EnumCheck)this.annotation).useEnumName()) {
            Enum<?>[] enumConstants;
            Class<Enum<?>> enumClass = ((EnumCheck)this.annotation).enumClass();
            for (Enum<?> enumConstant : enumConstants = enumClass.getEnumConstants()) {
                if (!Objects.equals(enumConstant.name(), value)) continue;
                return !((EnumCheck)this.annotation).reverse();
            }
            return ((EnumCheck)this.annotation).reverse();
        }
        if (StringUtils.isEmpty((Object)((EnumCheck)this.annotation).enumMethod())) {
            Class<? extends Enum<?>> enumClass = ((EnumCheck)this.annotation).enumClass();
            boolean isValid = this.existEnumCode(enumClass, String.valueOf(value), ((EnumCheck)this.annotation).enumField());
            return ((EnumCheck)this.annotation).reverse() ? !isValid : isValid;
        }
        return this.doValidByEnumMethod(value);
    }

    private boolean doValidByEnumMethod(Object value) {
        Class<? extends Enum<?>> enumClass = ((EnumCheck)this.annotation).enumClass();
        boolean isValid = false;
        try {
            Method method = this.getEnumMethod();
            Class<?> parameterType = method.getParameterTypes()[0];
            isValid = (Boolean)method.invoke(enumClass, this.castObjectValue(value, parameterType));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("EnumCheck enumClass not found " + ((EnumCheck)this.annotation).enumMethod() + " method.");
        }
        catch (Exception e) {
            throw new ValidationException((Throwable)e);
        }
        return ((EnumCheck)this.annotation).reverse() ? !isValid : isValid;
    }

    private Method getEnumMethod() throws NoSuchMethodException {
        String cacheKey = String.format("%s-%s", ((EnumCheck)this.annotation).enumClass().getName(), ((EnumCheck)this.annotation).enumMethod());
        Method method = enumMethodCache.get(((EnumCheck)this.annotation).enumMethod());
        if (method == null) {
            Method[] declaredMethods;
            for (Method declaredMethod : declaredMethods = ((EnumCheck)this.annotation).enumClass().getDeclaredMethods()) {
                if (!((EnumCheck)this.annotation).enumMethod().equals(declaredMethod.getName()) || declaredMethod.getParameterCount() != 1) continue;
                method = declaredMethod;
                ReflectionUtils.makeAccessible((Method)method);
                enumMethodCache.putIfAbsent(cacheKey, method);
                break;
            }
        }
        if (method == null) {
            throw new NoSuchMethodException();
        }
        return method;
    }

    private boolean existEnumCode(Class<?> clazz, String value, String key) {
        String cacheKey = String.format("%s-%s-%s", clazz.getName(), key, value);
        if (!enumCodeExistCache.containsKey(cacheKey)) {
            try {
                for (Object result : clazz.getEnumConstants()) {
                    Field codeField = result.getClass().getDeclaredField(key);
                    ReflectionUtils.makeAccessible((Field)codeField);
                    if (!value.equals(String.valueOf(ReflectionUtils.getField((Field)codeField, result)))) continue;
                    enumCodeExistCache.putIfAbsent(cacheKey, true);
                    break;
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return enumCodeExistCache.containsKey(cacheKey);
    }

    private String getConfigGroup() {
        return ApplicationContextHolder.getContext().getEnvironment().getProperty("emum-check.config-group", ((EnumCheck)this.annotation).configGroup());
    }

    private String getConfigName() {
        String configName = ((EnumCheck)this.annotation).configName();
        if (StringUtils.isEmpty((Object)configName) && StringUtils.isEmpty((Object)(configName = this.getValidBasePath(this.getContext())))) {
            throw new IllegalArgumentException("EnumCheck missing configuration.");
        }
        return configName;
    }

    private Object castObjectValue(Object value, Class<?> type) {
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        if (type == String.class) {
            return String.valueOf(value).trim();
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return Integer.valueOf(String.valueOf(value).trim());
        }
        if (type == Long.class || type == Long.TYPE) {
            return Long.valueOf(String.valueOf(value).trim());
        }
        if (type == Double.class || type == Double.TYPE) {
            return Double.valueOf(String.valueOf(value).trim());
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.valueOf(String.valueOf(value).trim());
        }
        return value;
    }

    public static enum Empty {

    }
}

