/*
 * Decompiled with CFR 0.152.
 */
package com.kanlon.language;

import com.kanlon.entity.DetectMode;
import com.kanlon.utils.GoogleTranslateUtil;
import com.kanlon.utils.JsonUtil;
import com.kanlon.utils.ShuyoLangDetectorUtil;
import com.kanlon.utils.StringUtil;
import java.math.BigDecimal;
import java.math.MathContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanguageDistinguish {
    private static Logger logger = LoggerFactory.getLogger(LanguageDistinguish.class);
    private static final String ENGLISH_CODE = "en";

    public static String getLanguageByString(String str, DetectMode mode) {
        boolean isOnlyOneLanguage;
        if (str == null || str.length() <= 0) {
            throw new IllegalArgumentException("\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
        }
        str = StringUtil.removeSpecialChar(str);
        StringBuilder noLetterAndNumBuilder = new StringBuilder();
        StringBuilder letterAndNumBuilder = new StringBuilder();
        String[] allStrs = str.split("\\s");
        for (int i = 0; i < allStrs.length; ++i) {
            boolean isLetterStr = true;
            for (int j = 0; j < allStrs[i].length(); ++j) {
                if (allStrs[i].charAt(j) <= '\u007f') continue;
                noLetterAndNumBuilder.append(allStrs[i]);
                noLetterAndNumBuilder.append(" ");
                isLetterStr = false;
                break;
            }
            if (!isLetterStr) continue;
            letterAndNumBuilder.append(allStrs[i]);
            letterAndNumBuilder.append(" ");
        }
        String noLetterAndNumLanguage = LanguageDistinguish.getBig127UnicodeLanguage(noLetterAndNumBuilder.toString());
        String letterLanguage = null;
        if (!StringUtil.isEmptyOrWhiteSpace(letterAndNumBuilder.toString())) {
            letterLanguage = ShuyoLangDetectorUtil.detect(letterAndNumBuilder.toString());
            if (mode.equals((Object)DetectMode.PRECISION) && !ENGLISH_CODE.equals(letterLanguage)) {
                letterLanguage = GoogleTranslateUtil.getLanguageFromGoogle(letterAndNumBuilder.toString());
            }
        }
        boolean bl = isOnlyOneLanguage = noLetterAndNumLanguage == null && letterLanguage == null || noLetterAndNumLanguage != null && noLetterAndNumLanguage.equals(letterLanguage);
        if (isOnlyOneLanguage) {
            return LanguageDistinguish.constructLanguageProportion(noLetterAndNumLanguage, noLetterAndNumBuilder.length(), null, 0);
        }
        return LanguageDistinguish.constructLanguageProportion(noLetterAndNumLanguage, noLetterAndNumBuilder.length(), letterLanguage, letterAndNumBuilder.length());
    }

    private static String getBig127UnicodeLanguage(String noLetterAndNumStr) {
        if (StringUtil.isEmptyOrWhiteSpace(noLetterAndNumStr)) {
            return null;
        }
        String languageStr = ShuyoLangDetectorUtil.detect(noLetterAndNumStr);
        if (StringUtil.isEmptyOrWhiteSpace(languageStr)) {
            languageStr = GoogleTranslateUtil.getLanguageFromGoogle(noLetterAndNumStr);
        }
        if (!StringUtil.isEmptyOrWhiteSpace(languageStr)) {
            return languageStr;
        }
        return languageStr;
    }

    public static Boolean isSpecialLanguage(char c) {
        int index = LanguageDistinguish.findIndexFromUnicodes(JsonUtil.getInstance().getSpecialLanguageUnicode(), c);
        return index > -1;
    }

    @Deprecated
    private static String getOneLanguageByUnicode(int unicode) {
        int maxUnicode = 65535;
        if (unicode < 0 || unicode > 65535) {
            throw new IllegalArgumentException("\u975e\u6b63\u5e38\u8bc6\u522b\u7684unicode\u6574\u6570\uff0c\u5f53\u524d\u53ea\u80fd\u8bc6\u522b\u7b2c\u4e00\u5e73\u9762\u7684");
        }
        Integer[] unicodes = JsonUtil.getInstance().getAbleJudgeUnicodes();
        String[] language = JsonUtil.getInstance().getAbleJudgeLanguages();
        int index = LanguageDistinguish.findIndexFromUnicodes(unicodes, unicode);
        if (index == -1) {
            return null;
        }
        return language[index / 2];
    }

    private static int findIndexFromUnicodes(Integer[] unicodesRange, int unicode) {
        if (unicodesRange == null || unicodesRange.length <= 1) {
            return -1;
        }
        int start = 0;
        int end = unicodesRange.length - 1;
        while (start <= end) {
            if (unicode < unicodesRange[start] || unicode > unicodesRange[end]) {
                return -1;
            }
            int midIndex = start + (end - start) / 2;
            if (unicode == unicodesRange[midIndex]) {
                return midIndex;
            }
            if (unicode < unicodesRange[midIndex]) {
                if (midIndex % 2 == 1) {
                    if (unicode >= unicodesRange[midIndex - 1]) {
                        return midIndex - 1;
                    }
                    end = midIndex - 2;
                    continue;
                }
                end = midIndex - 1;
                continue;
            }
            if (midIndex % 2 == 0) {
                if (unicode <= unicodesRange[midIndex + 1]) {
                    return midIndex + 1;
                }
                start = midIndex + 2;
                continue;
            }
            start = midIndex + 1;
        }
        return -1;
    }

    private static String constructLanguageProportion(String language1, int length1, String language2, int length2) {
        if (length1 + length2 <= 0) {
            return "{}";
        }
        StringBuilder returnBuilder = new StringBuilder();
        double sumLength = length1 + length2;
        BigDecimal proportion1 = new BigDecimal((double)length1 / sumLength, MathContext.DECIMAL32);
        BigDecimal proportion2 = new BigDecimal((double)length2 / sumLength, MathContext.DECIMAL32);
        BigDecimal minPrecision = new BigDecimal(0.01, MathContext.DECIMAL32);
        returnBuilder.append("{\"");
        if (proportion1.compareTo(minPrecision) <= 0 || proportion2.compareTo(minPrecision) <= 0) {
            if (proportion1.compareTo(minPrecision) <= 0) {
                returnBuilder.append(language2);
            } else {
                returnBuilder.append(language1);
            }
            returnBuilder.append("\":1.00}");
            return returnBuilder.toString();
        }
        returnBuilder.append(language1);
        returnBuilder.append("\":");
        returnBuilder.append(proportion1.setScale(2, 4).toString());
        returnBuilder.append(",\"");
        returnBuilder.append(language2);
        returnBuilder.append("\":");
        returnBuilder.append(proportion2.setScale(2, 4).toString());
        returnBuilder.append("}");
        return returnBuilder.toString();
    }
}

