/*
 * Decompiled with CFR 0.152.
 */
package com.kanlon.utils;

import com.kanlon.language.LanguageDistinguish;
import com.kanlon.utils.HttpRequestUtil;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleTranslateUtil {
    private static Logger logger = LoggerFactory.getLogger(GoogleTranslateUtil.class);
    private static long lastRequestTime = 0L;

    public static String getLanguageFromGoogle(String str) {
        logger.info("\u4f7f\u7528\u4e86\u8c37\u6b4c\u7ffb\u8bd1");
        String responseStr = null;
        String url = "https://translate.google.com/translate_a/single";
        StringBuilder param = new StringBuilder();
        param.append("client=webapp&sl=auto&tl=zh-CN&hl=zh-CN&dt=at&dt=bd&dt=ex&dt=ld&dt=md&dt=qca&dt=rw&dt=rm&dt=ss&dt=t&otf=1&ssel=3&tsel=0&kc=1");
        param.append("&tk=");
        param.append(GoogleTranslateUtil.token(str));
        param.append("&q=");
        try {
            param.append(URLEncoder.encode(str, "UTF-8"));
            long startTime = System.currentTimeMillis();
            long startNanoTime = System.nanoTime();
            long currentTime = System.nanoTime();
            long betweenTime = (currentTime - lastRequestTime) / 1000000L;
            Thread.sleep(betweenTime > 1000L ? 0L : 1000L - betweenTime);
            responseStr = HttpRequestUtil.sendGet(url, param.toString());
            lastRequestTime = System.nanoTime();
            logger.info("\u6240\u7528\u7eb3\u79d2\u65f6\u95f4\uff1a" + (System.nanoTime() - startNanoTime) + "\uff0c\u5171\uff1a" + (System.currentTimeMillis() - startTime) + "\u6beb\u79d2");
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u8c37\u6b4c\u7ffb\u8bd1\u529f\u80fd\u8bc6\u522b\u8bed\u8a00\u7c7b\u522b\u51fa\u73b0\u9519\u8bef", (Throwable)e);
        }
        JSONObject jsonObject = new JSONObject("{\"result\":" + responseStr + "}");
        JSONArray array = jsonObject.getJSONArray("result");
        responseStr = array.get(2) == null ? null : array.get(2).toString();
        return responseStr;
    }

    private static String token(String text) {
        String tk = "";
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("js");
        try {
            engine.eval(new InputStreamReader(LanguageDistinguish.class.getClassLoader().getResourceAsStream("Google.js")));
            if (engine instanceof Invocable) {
                Invocable invoke = (Invocable)((Object)engine);
                tk = String.valueOf(invoke.invokeFunction("token", text));
            }
        }
        catch (Exception e) {
            logger.error("\u672a\u77e5\u83b7\u53d6\u8c37\u6b4c\u7ffb\u8bd1\u7684tk\u503c\u65f6\u7684\u9519\u8bef\uff1a", (Throwable)e);
        }
        return tk;
    }
}

