/*
 * Decompiled with CFR 0.152.
 */
package com.kanlon.utils;

import com.kanlon.entity.JsonKeyType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class JsonUtil {
    private static JsonUtil INSTANCE = new JsonUtil();
    private JSONObject jsonObject;
    private List<Integer> ableJudgeUnicodes = new ArrayList<Integer>();
    private List<String> ableJudgeLanguages = new ArrayList<String>();
    private List<Integer> specialLanguageUnicode = new ArrayList<Integer>();

    private JsonUtil() {
        InputStream inputStream = JsonUtil.class.getClassLoader().getResourceAsStream("language-unicode-info.json");
        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream, Charset.forName("UTF-8")));
        StringBuffer jsonStr = new StringBuffer();
        String line = null;
        while (true) {
            try {
                line = in.readLine();
                if (line == null) {
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            jsonStr.append(line);
        }
        this.jsonObject = new JSONObject(jsonStr.toString());
        JSONObject ableJudgeJson = this.jsonObject.getJSONObject(JsonKeyType.ABLE_JUDGE_BY_UNICODE.toString());
        for (String key : ableJudgeJson.keySet()) {
            String[] unicodeRange = key.split("-");
            this.ableJudgeUnicodes.add(Integer.parseInt(unicodeRange[0], 16));
            this.ableJudgeUnicodes.add(Integer.parseInt(unicodeRange[1], 16));
            this.ableJudgeLanguages.add(ableJudgeJson.getString(key));
        }
        Collections.sort(this.ableJudgeUnicodes);
        JSONObject specialJson = this.jsonObject.getJSONObject(JsonKeyType.SPECIAL_LANGUAGE_UNICODE.toString());
        for (String key : specialJson.keySet()) {
            String[] unicodeRange = key.split("-");
            this.specialLanguageUnicode.add(Integer.parseInt(unicodeRange[0], 16));
            this.specialLanguageUnicode.add(Integer.parseInt(unicodeRange[1], 16));
        }
        Collections.sort(this.specialLanguageUnicode);
    }

    public Map<String, Object> getLanguageInfoByKey(JsonKeyType keyType) {
        return this.jsonObject.getJSONObject(keyType.toString()).toMap();
    }

    public List<String> getTestStr() {
        ArrayList<String> list = new ArrayList<String>();
        List objects = this.jsonObject.getJSONArray("test-str").toList();
        for (Object obj : objects) {
            list.add(obj.toString());
        }
        return list;
    }

    public JSONObject getJsonObject() {
        return this.jsonObject;
    }

    public Integer[] getAbleJudgeUnicodes() {
        return this.ableJudgeUnicodes.toArray(new Integer[this.ableJudgeUnicodes.size()]);
    }

    public String[] getAbleJudgeLanguages() {
        return this.ableJudgeLanguages.toArray(new String[this.ableJudgeLanguages.size()]);
    }

    public Integer[] getSpecialLanguageUnicode() {
        return this.specialLanguageUnicode.toArray(new Integer[this.specialLanguageUnicode.size()]);
    }

    public static JsonUtil getInstance() {
        return INSTANCE;
    }
}

