/*
 * Decompiled with CFR 0.152.
 */
package com.kanlon.utils;

import com.cybozu.labs.langdetect.Detector;
import com.cybozu.labs.langdetect.DetectorFactory;
import com.cybozu.labs.langdetect.LangDetectException;
import com.kanlon.utils.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuyoLangDetectorUtil {
    private static Logger logger = LoggerFactory.getLogger(ShuyoLangDetectorUtil.class);
    private static final String LANG_PATH = "lang";

    public static String detect(String originalStr) {
        if (StringUtil.isEmptyOrWhiteSpace(originalStr)) {
            return null;
        }
        String langUsed = "";
        try {
            Detector detector = DetectorFactory.create();
            detector.append(originalStr);
            langUsed = detector.detect();
        }
        catch (LangDetectException e) {
            logger.warn("\u8bc6\u522b\uff1a\u201c" + originalStr + "\u201d\u5931\u8d25\u3002", (Throwable)e);
            for (int i = 0; i < originalStr.length(); ++i) {
                System.out.print(Integer.toHexString(originalStr.charAt(i)) + " ");
            }
        }
        return langUsed;
    }

    private static List<String> getProfileStr() {
        ArrayList<String> list = new ArrayList<String>();
        String path = ShuyoLangDetectorUtil.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        JarFile localJarFile = null;
        try {
            localJarFile = new JarFile(new File(path));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Enumeration<JarEntry> files = localJarFile.entries();
        while (files.hasMoreElements()) {
            String innerFile = files.nextElement().getName();
            if (!innerFile.startsWith("lang/")) continue;
            logger.info("\u52a0\u8f7d\u4e86\uff1a" + innerFile);
            InputStream inputStream = ShuyoLangDetectorUtil.class.getClassLoader().getResourceAsStream(innerFile);
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder builder = new StringBuilder();
            try {
                String line = br.readLine();
                if (line != null) {
                    builder.append(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            list.add(builder.toString());
        }
        return list;
    }

    static {
        try {
            String path = ShuyoLangDetectorUtil.class.getClassLoader().getResource(LANG_PATH).getPath();
            File langFile = new File(path);
            if (langFile.exists()) {
                DetectorFactory.loadProfile((File)langFile);
            } else {
                logger.info("\u52a0\u8f7d\u9ed8\u8ba4\u7684\u8bed\u8a00\u5e93");
                DetectorFactory.loadProfile(ShuyoLangDetectorUtil.getProfileStr());
            }
        }
        catch (LangDetectException e) {
            e.printStackTrace();
        }
    }
}

