/*
 * Decompiled with CFR 0.152.
 */
package com.kanlon.utils;

import com.kanlon.language.LanguageDistinguish;

public class StringUtil {
    private StringUtil() {
    }

    public static String string2Unicode(String str) {
        if (str == null || str.length() <= 0) {
            return null;
        }
        StringBuffer unicode = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            unicode.append("\\u" + Integer.toHexString(c));
        }
        return unicode.toString();
    }

    public static int[] string2UnicodeInts(String str) {
        if (str == null || str.length() <= 0) {
            return null;
        }
        int[] unicodes = new int[str.length()];
        for (int i = 0; i < str.length(); ++i) {
            unicodes[i] = str.charAt(i);
        }
        return unicodes;
    }

    public static String removeSpecialChar(String str) {
        if (str == null || str.length() <= 0) {
            return null;
        }
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] >= '\ud800' && chars[i] <= '\udbff') {
                chars[i] = 32;
                chars[++i] = 32;
            }
            if (!LanguageDistinguish.isSpecialLanguage(chars[i]).booleanValue()) continue;
            chars[i] = 32;
        }
        str = new String(chars);
        String reg = "[a-zA-z]+://[^\\s]*";
        str = str.replaceAll(reg, "");
        String emailReg = "[a-zA-z0-9]+@[^\\s]*";
        str = str.replaceAll(emailReg, "");
        String signReg = "[!@#\\$%\\^&\\*\\(\\)_\\+=\\{\\}\\\\\\[\\]\\?\\/\\|#:><;\\-'\",\u0301`~\\.]";
        str = str.replaceAll(signReg, " ");
        String numReg = "(([0-9]+[\\s]+)|([\\s]+[0-9]+))";
        str = str.replaceAll(numReg, "");
        str = str.replaceAll("\\s+", " ");
        return str;
    }

    public static boolean isEmptyOrWhiteSpace(String str) {
        return str == null || str.length() <= 0 || str.matches("\\s");
    }
}

