/*
 * Decompiled with CFR 0.152.
 */
package com.kanlon.utils.baidu;

import com.kanlon.utils.StringUtil;
import com.kanlon.utils.baidu.TransApi;
import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaiduLanguageUtil {
    private static Logger logger = LoggerFactory.getLogger(BaiduLanguageUtil.class);
    private static String APP_ID = "";
    private static String SECURITY_KEY = "";

    public BaiduLanguageUtil(String appID, String securityKey) {
        APP_ID = appID;
        SECURITY_KEY = securityKey;
    }

    private static String getLanguageFromBaidu(String str) {
        if (StringUtil.isEmptyOrWhiteSpace(APP_ID) || StringUtil.isEmptyOrWhiteSpace(SECURITY_KEY)) {
            throw new RuntimeException("\u8fd8\u6ca1\u8bbe\u7f6eAPP_ID\u548cSECURITY_KEY");
        }
        logger.info("\u4f7f\u7528\u4e86\u767e\u5ea6\u7ffb\u8bd1");
        String language = null;
        TransApi api = new TransApi(APP_ID, SECURITY_KEY);
        String result = api.getTransResult(str, "auto", "en");
        JSONObject object = new JSONObject(result);
        Map map = object.toMap();
        String languageKey = "from";
        String errorCodeKey = "error_code";
        String signErrorCode = "54001";
        String passwordErrorCode = "52003";
        String tooQuickRequestErrorCode = "54003";
        String tooMoreRequestErrorCode = "54004";
        if (map.get("from") == null) {
            String errorCode = map.get("error_code").toString();
            if ("54001".equals(errorCode) || "52003".equals(errorCode)) {
                logger.error("\u7b7e\u540d\u9519\u8bef,\u8bf7\u68c0\u67e5app-id\u548c\u5bc6\u7801\u662f\u5426\u586b\u5199\u6b63\u786e," + result);
            } else if ("54003".equals(errorCode)) {
                logger.error("\u8c03\u7528\u9891\u7387\u592a\u9ad8\uff0c\u8bf7\u964d\u4f4e\u8c03\u7528\u9891\u7387," + result);
            } else if ("54004".equals(errorCode)) {
                logger.error("\u514d\u8d39\u6b21\u6570\u5df2\u7ecf\u7528\u5b8c\uff0c\u8bf7\u5145\u503c," + result);
            } else {
                logger.error("\u5176\u4ed6\u539f\u56e0\uff0c" + result);
            }
            return language;
        }
        String languageCode = map.get("from").toString();
        return languageCode;
    }
}

