/*
 * Decompiled with CFR 0.152.
 */
package springdao;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import springdao.Dao;
import springdao.DaoManager;
import springdao.DaoRepository;
import springdao.RepositoryManager;
import springdao.support.AbstractSpringDao;
import springdao.support.SimpleSpringDao;

public class DaoAnnotationBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements Ordered,
ApplicationContextAware {
    private static final Logger log = LogManager.getLogger(DaoAnnotationBeanPostProcessor.class);
    private ApplicationContext context;
    private ConfigurableApplicationContext regContext;
    private static final AtomicInteger defcnt = new AtomicInteger(0);

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
        if (applicationContext instanceof ConfigurableApplicationContext) {
            this.regContext = (ConfigurableApplicationContext)applicationContext;
        }
    }

    public <T> T getBean(String name, Class<T> requiredType) {
        try {
            return (T)this.context.getBean(name, requiredType);
        }
        catch (NoSuchBeanDefinitionException ex) {
            log.warn("Bean name '{}' with {} not exists.", (Object)name, (Object)requiredType.getSimpleName());
            return null;
        }
        catch (BeansException ex) {
            log.warn(String.format("Can't get %s[%s] bean.", requiredType.getSimpleName(), name), (Throwable)ex);
            return null;
        }
    }

    private String convertName(String orgName) {
        String[] names = orgName.split("\\.");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < names.length; ++i) {
            if (i == 0) {
                sb.append(String.valueOf(names[i].charAt(0)).toLowerCase()).append(names[i].substring(1));
                continue;
            }
            sb.append(String.valueOf(names[i].charAt(0)).toUpperCase()).append(names[i].substring(1));
        }
        return sb.toString();
    }

    public Object postProcessBeforeInitialization(final Object bean, String beanName) throws BeansException {
        ReflectionUtils.doWithFields(bean.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                DaoManager ormm;
                Dao dao = field.getAnnotation(Dao.class);
                if (dao != null) {
                    DaoRepository resultDao;
                    ParameterizedType pt;
                    Type[] typeArguments;
                    Class genericType;
                    Class clazz = genericType = dao.value().equals(Object.class) ? null : dao.value();
                    if (genericType == null && field.getGenericType() instanceof ParameterizedType && (typeArguments = (pt = (ParameterizedType)field.getGenericType()).getActualTypeArguments()) != null & typeArguments.length > 0) {
                        genericType = (Class)typeArguments[0];
                    }
                    if (genericType == null) {
                        throw new IllegalArgumentException("@Dao field should assoicate a Generic ParameterizedType like DaoManager<Type> " + field.getName() + " or annotated with @Dao(assocationType.class)");
                    }
                    Class assoicateType = genericType;
                    String daoName = StringUtils.hasText((String)dao.name()) ? dao.name() : (dao.autoRegister() ? String.format("%sDao", DaoAnnotationBeanPostProcessor.this.convertName(DaoRepository.class.equals(field.getType()) ? assoicateType.getSimpleName() : field.getType().getName())) : String.format("%sDao_%d", DaoAnnotationBeanPostProcessor.this.convertName(assoicateType.getSimpleName()), defcnt.getAndAdd(1)));
                    DaoRepository daoRepository = resultDao = daoName != null && !daoName.isEmpty() ? DaoAnnotationBeanPostProcessor.this.getBean(daoName, DaoRepository.class) : null;
                    if (resultDao == null) {
                        GenericBeanDefinition beanDefinition;
                        BeanDefinitionRegistry registry;
                        if (ClassUtils.isAssignable(field.getType(), AbstractSpringDao.class)) {
                            registry = (BeanDefinitionRegistry)DaoAnnotationBeanPostProcessor.this.regContext.getBeanFactory();
                            beanDefinition = new GenericBeanDefinition();
                            beanDefinition.setBeanClass(SimpleSpringDao.class);
                            beanDefinition.setLazyInit(false);
                            beanDefinition.setAbstract(false);
                            beanDefinition.setAutowireCandidate(true);
                            beanDefinition.setScope("singleton");
                            beanDefinition.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)assoicateType);
                            registry.registerBeanDefinition(daoName, (BeanDefinition)beanDefinition);
                            resultDao = (DaoRepository)DaoAnnotationBeanPostProcessor.this.context.getBean(daoName);
                        } else if (ClassUtils.isAssignable(DaoRepository.class, field.getType())) {
                            registry = (BeanDefinitionRegistry)DaoAnnotationBeanPostProcessor.this.regContext.getBeanFactory();
                            beanDefinition = new GenericBeanDefinition();
                            beanDefinition.setBeanClass(field.getType());
                            beanDefinition.setLazyInit(false);
                            beanDefinition.setAbstract(false);
                            beanDefinition.setAutowireCandidate(true);
                            beanDefinition.setScope("singleton");
                            registry.registerBeanDefinition(daoName, (BeanDefinition)beanDefinition);
                            resultDao = (DaoRepository)DaoAnnotationBeanPostProcessor.this.context.getBean(daoName);
                        } else {
                            throw new BeanNotOfRequiredTypeException(field.getName(), DaoRepository.class, field.getType());
                        }
                        log.debug("Build, and inject field with bean {}@{}<{}>", (Object)daoName, (Object)resultDao.getClass().getSimpleName(), (Object)assoicateType.getSimpleName());
                    }
                    ReflectionUtils.makeAccessible((Field)field);
                    field.set(bean, resultDao);
                }
                if ((ormm = field.getAnnotation(DaoManager.class)) != null) {
                    ParameterizedType pt;
                    Type[] typeArguments;
                    Class genericType;
                    Class clazz = genericType = ormm.value().equals(Object.class) ? null : ormm.value();
                    if (genericType == null && field.getGenericType() instanceof ParameterizedType && (typeArguments = (pt = (ParameterizedType)field.getGenericType()).getActualTypeArguments()) != null & typeArguments.length > 0) {
                        genericType = (Class)typeArguments[0];
                    }
                    if (genericType == null) {
                        throw new IllegalArgumentException("@DaoManager field should assoicate a Generic ParameterizedType like RepositoryManager<Type> " + field.getName() + " or annotated with @DaoManager(assocationType.class)");
                    }
                    Class assoicateType = genericType;
                    String mgrName = StringUtils.hasText((String)ormm.name()) ? ormm.name() : (ormm.autoRegister() ? String.format("%sManager", DaoAnnotationBeanPostProcessor.this.convertName(RepositoryManager.class.equals(field.getType()) ? assoicateType.getSimpleName() : field.getType().getName())) : String.format("%sManager_%d", DaoAnnotationBeanPostProcessor.this.convertName(assoicateType.getSimpleName()), defcnt.getAndAdd(1)));
                    RepositoryManager resultManager = mgrName != null && !mgrName.isEmpty() ? DaoAnnotationBeanPostProcessor.this.getBean(mgrName, RepositoryManager.class) : null;
                    Class<?> fc = field.getType();
                    if (resultManager == null) {
                        GenericBeanDefinition beanDefinition;
                        BeanDefinitionRegistry registry;
                        if (ClassUtils.isAssignable(ormm.baseManagerType(), fc)) {
                            registry = (BeanDefinitionRegistry)DaoAnnotationBeanPostProcessor.this.regContext.getBeanFactory();
                            beanDefinition = new GenericBeanDefinition();
                            beanDefinition.setBeanClass(fc);
                            beanDefinition.setLazyInit(false);
                            beanDefinition.setAbstract(false);
                            beanDefinition.setAutowireCandidate(true);
                            beanDefinition.setScope("singleton");
                            registry.registerBeanDefinition(mgrName, (BeanDefinition)beanDefinition);
                            resultManager = (RepositoryManager)DaoAnnotationBeanPostProcessor.this.context.getBean(mgrName);
                        } else if (ClassUtils.isAssignable(fc, ormm.baseManagerType())) {
                            registry = (BeanDefinitionRegistry)DaoAnnotationBeanPostProcessor.this.regContext.getBeanFactory();
                            beanDefinition = new GenericBeanDefinition();
                            beanDefinition.setBeanClass(ormm.baseManagerType());
                            beanDefinition.setLazyInit(false);
                            beanDefinition.setAbstract(false);
                            beanDefinition.setAutowireCandidate(true);
                            beanDefinition.setScope("singleton");
                            registry.registerBeanDefinition(mgrName, (BeanDefinition)beanDefinition);
                            resultManager = (RepositoryManager)DaoAnnotationBeanPostProcessor.this.context.getBean(mgrName);
                        }
                    }
                    if (resultManager.getDao() == null) {
                        DaoRepository resultDao;
                        String daoName = StringUtils.hasText((String)ormm.daoName()) ? ormm.daoName() : (ormm.autoRegister() ? String.format("%sDao", DaoAnnotationBeanPostProcessor.this.convertName(assoicateType.getSimpleName())) : String.format("%sDao_%d", DaoAnnotationBeanPostProcessor.this.convertName(assoicateType.getSimpleName()), defcnt.getAndAdd(1)));
                        DaoRepository daoRepository = resultDao = StringUtils.hasText((String)daoName) ? DaoAnnotationBeanPostProcessor.this.getBean(daoName, DaoRepository.class) : null;
                        if (resultDao == null) {
                            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)DaoAnnotationBeanPostProcessor.this.regContext.getBeanFactory();
                            GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
                            beanDefinition.setBeanClass(SimpleSpringDao.class);
                            beanDefinition.setLazyInit(false);
                            beanDefinition.setAbstract(false);
                            beanDefinition.setAutowireCandidate(true);
                            beanDefinition.setScope("singleton");
                            beanDefinition.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)assoicateType);
                            registry.registerBeanDefinition(daoName, (BeanDefinition)beanDefinition);
                            resultDao = (DaoRepository)DaoAnnotationBeanPostProcessor.this.context.getBean(daoName);
                        }
                        resultManager.setDao(resultDao);
                    }
                    ReflectionUtils.makeAccessible((Field)field);
                    log.debug("Inject {} with {}", (Object)field.getName(), resultManager.getClass());
                    field.set(bean, resultManager);
                }
            }
        });
        ReflectionUtils.doWithMethods(bean.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                DaoManager ormm;
                Class<?>[] parmatypes = method.getParameterTypes();
                Class<?> fc = parmatypes.length > 0 ? parmatypes[0] : null;
                Dao dao = method.getAnnotation(Dao.class);
                if (dao != null && fc != null && Void.TYPE.equals(method.getReturnType()) && ClassUtils.isAssignable(DaoRepository.class, fc)) {
                    DaoRepository resultDao;
                    ParameterizedType aType;
                    Type[] parameterArgTypes;
                    Type[] genericParameterTypes;
                    Class genericType;
                    Class clazz = genericType = dao.value().equals(Object.class) ? null : dao.value();
                    if (genericType == null && (genericParameterTypes = method.getGenericParameterTypes())[0] instanceof ParameterizedType && (parameterArgTypes = (aType = (ParameterizedType)genericParameterTypes[0]).getActualTypeArguments()).length == 1) {
                        genericType = (Class)parameterArgTypes[0];
                    }
                    if (genericType == null) {
                        throw new IllegalArgumentException("@Dao Method should assoicate a Generic ParameterizedType like " + method.getName() + "(DaoRepository<Type>)  or annotated with @Dao(assocationType.class) ");
                    }
                    Class assoicateType = genericType;
                    String daoName = StringUtils.hasText((String)dao.name()) ? dao.name() : (dao.autoRegister() ? String.format("%sDao", DaoAnnotationBeanPostProcessor.this.convertName(DaoRepository.class.equals(fc) ? assoicateType.getSimpleName() : fc.getName())) : String.format("%sDao_%d", DaoAnnotationBeanPostProcessor.this.convertName(assoicateType.getSimpleName()), defcnt.getAndAdd(1)));
                    DaoRepository daoRepository = resultDao = daoName != null && !daoName.isEmpty() ? DaoAnnotationBeanPostProcessor.this.getBean(daoName, DaoRepository.class) : null;
                    if (resultDao == null) {
                        GenericBeanDefinition beanDefinition;
                        BeanDefinitionRegistry registry;
                        if (ClassUtils.isAssignable(fc, AbstractSpringDao.class)) {
                            registry = (BeanDefinitionRegistry)DaoAnnotationBeanPostProcessor.this.regContext.getBeanFactory();
                            beanDefinition = new GenericBeanDefinition();
                            beanDefinition.setBeanClass(SimpleSpringDao.class);
                            beanDefinition.setLazyInit(false);
                            beanDefinition.setAbstract(false);
                            beanDefinition.setAutowireCandidate(true);
                            beanDefinition.setScope("singleton");
                            beanDefinition.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)assoicateType);
                            registry.registerBeanDefinition(daoName, (BeanDefinition)beanDefinition);
                            resultDao = (DaoRepository)DaoAnnotationBeanPostProcessor.this.context.getBean(daoName);
                        } else {
                            registry = (BeanDefinitionRegistry)DaoAnnotationBeanPostProcessor.this.regContext.getBeanFactory();
                            beanDefinition = new GenericBeanDefinition();
                            beanDefinition.setBeanClass(fc);
                            beanDefinition.setLazyInit(false);
                            beanDefinition.setAbstract(false);
                            beanDefinition.setAutowireCandidate(true);
                            beanDefinition.setScope("singleton");
                            registry.registerBeanDefinition(daoName, (BeanDefinition)beanDefinition);
                            resultDao = (DaoRepository)DaoAnnotationBeanPostProcessor.this.context.getBean(daoName);
                        }
                    }
                    ReflectionUtils.makeAccessible((Method)method);
                    try {
                        log.debug("Inject {}({}) with {}", new Object[]{method.getName(), fc.getSimpleName(), resultDao.getClass()});
                        method.invoke(bean, resultDao);
                    }
                    catch (InvocationTargetException ex) {
                        log.error(ex.getMessage(), (Throwable)ex);
                    }
                }
                if ((ormm = method.getAnnotation(DaoManager.class)) != null && fc != null && Void.TYPE.equals(method.getReturnType()) && (ClassUtils.isAssignable(fc, ormm.baseManagerType()) || ClassUtils.isAssignable(ormm.baseManagerType(), fc))) {
                    RepositoryManager resultManager;
                    ParameterizedType aType;
                    Type[] parameterArgTypes;
                    Type[] genericParameterTypes;
                    Class genericType;
                    Class clazz = genericType = ormm.value().equals(Object.class) ? null : ormm.value();
                    if (genericType == null && (genericParameterTypes = method.getGenericParameterTypes())[0] instanceof ParameterizedType && (parameterArgTypes = (aType = (ParameterizedType)genericParameterTypes[0]).getActualTypeArguments()).length == 1) {
                        genericType = (Class)parameterArgTypes[0];
                    }
                    if (genericType == null) {
                        throw new IllegalArgumentException("@DaoMethod Method should assoicate a Generic ParameterizedType like " + method.getName() + "(RepositoryManager<Type>)  or annotated with @DaoManager(assocationType.class)");
                    }
                    Class assoicateType = genericType;
                    String mgrName = StringUtils.hasText((String)ormm.name()) ? ormm.name() : (ormm.autoRegister() ? String.format("%sManager", DaoAnnotationBeanPostProcessor.this.convertName(RepositoryManager.class.equals(method.getReturnType()) ? assoicateType.getSimpleName() : fc.getName())) : String.format("%sManager_%d", DaoAnnotationBeanPostProcessor.this.convertName(assoicateType.getSimpleName()), defcnt.getAndAdd(1)));
                    RepositoryManager repositoryManager = resultManager = StringUtils.hasText((String)mgrName) ? DaoAnnotationBeanPostProcessor.this.getBean(mgrName, RepositoryManager.class) : null;
                    if (resultManager == null) {
                        GenericBeanDefinition beanDefinition;
                        BeanDefinitionRegistry registry;
                        if (ClassUtils.isAssignable(ormm.baseManagerType(), fc)) {
                            registry = (BeanDefinitionRegistry)DaoAnnotationBeanPostProcessor.this.regContext.getBeanFactory();
                            beanDefinition = new GenericBeanDefinition();
                            beanDefinition.setBeanClass(fc);
                            beanDefinition.setLazyInit(false);
                            beanDefinition.setAbstract(false);
                            beanDefinition.setAutowireCandidate(true);
                            beanDefinition.setScope("singleton");
                            registry.registerBeanDefinition(mgrName, (BeanDefinition)beanDefinition);
                            resultManager = (RepositoryManager)DaoAnnotationBeanPostProcessor.this.context.getBean(mgrName);
                        } else if (ClassUtils.isAssignable(fc, ormm.baseManagerType())) {
                            registry = (BeanDefinitionRegistry)DaoAnnotationBeanPostProcessor.this.regContext.getBeanFactory();
                            beanDefinition = new GenericBeanDefinition();
                            beanDefinition.setBeanClass(ormm.baseManagerType());
                            beanDefinition.setLazyInit(false);
                            beanDefinition.setAbstract(false);
                            beanDefinition.setAutowireCandidate(true);
                            beanDefinition.setScope("singleton");
                            registry.registerBeanDefinition(mgrName, (BeanDefinition)beanDefinition);
                            resultManager = (RepositoryManager)DaoAnnotationBeanPostProcessor.this.context.getBean(mgrName);
                        }
                    }
                    if (resultManager.getDao() == null) {
                        DaoRepository resultDao;
                        String daoName = StringUtils.hasText((String)ormm.daoName()) ? ormm.daoName() : (ormm.autoRegister() ? String.format("%sDao", DaoAnnotationBeanPostProcessor.this.convertName(assoicateType.getSimpleName())) : String.format("%sDao_%d", DaoAnnotationBeanPostProcessor.this.convertName(assoicateType.getSimpleName()), defcnt.getAndAdd(1)));
                        DaoRepository daoRepository = resultDao = StringUtils.hasText((String)daoName) ? DaoAnnotationBeanPostProcessor.this.getBean(daoName, DaoRepository.class) : null;
                        if (resultDao == null) {
                            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)DaoAnnotationBeanPostProcessor.this.regContext.getBeanFactory();
                            GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
                            beanDefinition.setBeanClass(SimpleSpringDao.class);
                            beanDefinition.setLazyInit(false);
                            beanDefinition.setAbstract(false);
                            beanDefinition.setAutowireCandidate(true);
                            beanDefinition.setScope("singleton");
                            beanDefinition.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)assoicateType);
                            registry.registerBeanDefinition(daoName, (BeanDefinition)beanDefinition);
                            resultDao = (DaoRepository)DaoAnnotationBeanPostProcessor.this.context.getBean(daoName);
                        }
                        resultManager.setDao(resultDao);
                    }
                    ReflectionUtils.makeAccessible((Method)method);
                    try {
                        log.debug("Inject {}({}) with {}", new Object[]{method.getName(), fc.getSimpleName(), resultManager.getClass()});
                        method.invoke(bean, resultManager);
                    }
                    catch (InvocationTargetException ex) {
                        log.error(ex.getMessage(), (Throwable)ex);
                    }
                }
            }
        });
        return bean;
    }
}

