/*
 * Decompiled with CFR 0.152.
 */
package springdao.support;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceException;
import javax.persistence.PersistenceUnit;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.Query;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.DaoSupport;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import springdao.DaoRepository;
import springdao.support.AliasHelper;
import springdao.support.JpqlHelper;

public abstract class AbstractSpringDao<E>
extends DaoSupport
implements DaoRepository<E> {
    private static final Logger log = LogManager.getLogger(AbstractSpringDao.class);
    private EntityManagerFactory emf;
    private EntityManager em;

    protected void checkDaoConfig() throws IllegalArgumentException {
        if (this.emf == null) {
            throw new IllegalArgumentException("'EntityManagerFactory' is required");
        }
        if (this.em == null) {
            throw new IllegalArgumentException("'EntityManager' is required");
        }
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.emf;
    }

    @PersistenceUnit
    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.emf = emf;
    }

    public EntityManager getEntityManager() {
        return this.em;
    }

    @PersistenceContext
    public void setEntityManager(EntityManager em) {
        this.em = em;
    }

    LockModeType getLockMode(String lockMode) {
        try {
            return LockModeType.valueOf((String)lockMode);
        }
        catch (RuntimeException ex) {
            return LockModeType.NONE;
        }
    }

    @Override
    public E instanate() throws InstantiationException, IllegalAccessException {
        try {
            return (E)this.getClazz().newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            log.error("Instanate error", (Throwable)ex);
            throw ex;
        }
    }

    protected RuntimeException convertException(Exception e) {
        if (e instanceof RuntimeException) {
            DataAccessException res = EntityManagerFactoryUtils.convertJpaAccessExceptionIfPossible((RuntimeException)((RuntimeException)e));
            return res == null ? (RuntimeException)e : res;
        }
        return new RuntimeException(e.getMessage(), e);
    }

    @Override
    public void clear() {
        try {
            this.em.clear();
        }
        catch (RuntimeException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public boolean contains(Object entity) {
        try {
            return this.em.contains(entity);
        }
        catch (RuntimeException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public E findByPrimaryKey(Serializable primaryKey) {
        try {
            return (E)this.em.find(this.getClazz(), (Object)primaryKey);
        }
        catch (RuntimeException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public E findByPrimaryKey(Serializable primaryKey, String lockMode) {
        try {
            return (E)this.em.find(this.getClazz(), (Object)primaryKey, this.getLockMode(lockMode));
        }
        catch (RuntimeException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public E findByPrimaryKey(Serializable primaryKey, Map<String, Object> properties) {
        try {
            return (E)this.em.find(this.getClazz(), (Object)primaryKey, properties);
        }
        catch (RuntimeException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public E findByPrimaryKey(Serializable primaryKey, String lockMode, Map<String, Object> properties) {
        try {
            return (E)this.em.find(this.getClazz(), (Object)primaryKey, this.getLockMode(lockMode), properties);
        }
        catch (RuntimeException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public E save(E entity) {
        return this.persist(entity);
    }

    @Override
    public Collection<E> save(Collection<E> entities) {
        try {
            ArrayList<E> result = new ArrayList<E>(entities.size());
            for (E entity : entities) {
                result.add(this.persist(entity));
            }
            this.em.flush();
            return result;
        }
        catch (RuntimeException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public E persist(E entity) {
        try {
            this.em.persist(entity);
            this.em.flush();
            return entity;
        }
        catch (RuntimeException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public E update(E entity) {
        return this.merge(entity);
    }

    @Override
    public Collection<E> update(Collection<E> entities) {
        return this.merge(entities);
    }

    @Override
    public E merge(E entity) {
        try {
            Object result = this.em.merge(entity);
            this.em.flush();
            return (E)result;
        }
        catch (RuntimeException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public Collection<E> merge(Collection<E> entities) {
        try {
            ArrayList<Object> result = new ArrayList<Object>(entities.size());
            for (E entity : entities) {
                result.add(this.em.merge(entity));
            }
            this.em.flush();
            return result;
        }
        catch (RuntimeException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public E saveOrUpdate(E entity) {
        return this.contains(entity) ? this.merge(entity) : (this.emf.getPersistenceUnitUtil().getIdentifier(entity) == null ? this.persist(entity) : this.merge(entity));
    }

    @Override
    public Collection<E> saveOrUpdate(Collection<E> entities) {
        try {
            ArrayList<E> result = new ArrayList<E>(entities.size());
            for (E entity : entities) {
                result.add(this.saveOrUpdate(entity));
            }
            this.em.flush();
            return result;
        }
        catch (RuntimeException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public void delete(Serializable primaryKey) {
        try {
            Object entity = this.em.find(this.getClazz(), (Object)primaryKey);
            if (entity != null) {
                this.em.remove(entity);
                this.em.flush();
            }
        }
        catch (RuntimeException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public void delete(Serializable primaryKey, String lockMode) {
        try {
            Object entity = this.em.find(this.getClazz(), (Object)primaryKey, this.getLockMode(lockMode));
            if (entity != null) {
                this.em.remove(entity);
                this.em.flush();
            }
        }
        catch (RuntimeException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public void delete(Collection<? extends Serializable> primaryKeys) {
        try {
            for (Serializable serializable : primaryKeys) {
                Object entity = this.em.find(this.getClazz(), (Object)serializable);
                if (entity == null) continue;
                this.em.remove(entity);
            }
            this.em.flush();
        }
        catch (RuntimeException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public E remove(E entity) {
        entity = this.merge(entity);
        try {
            this.em.remove(entity);
            this.em.flush();
            return entity;
        }
        catch (RuntimeException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public E remove(E entity, String lockMode) {
        Object pk = this.emf.getPersistenceUnitUtil().getIdentifier(entity);
        if (pk == null) {
            return null;
        }
        entity = this.em.find(this.getClazz(), pk, this.getLockMode(lockMode));
        if (entity == null) {
            return null;
        }
        this.em.remove(entity);
        this.em.flush();
        return entity;
    }

    @Override
    public Collection<E> remove(Collection<E> entities) {
        try {
            ArrayList<E> result = new ArrayList<E>(entities.size());
            for (E entity : entities) {
                entity = this.merge(entity);
                this.em.remove(entity);
                result.add(entity);
            }
            this.em.flush();
            return result;
        }
        catch (RuntimeException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public E lock(E entity, String lockMode) {
        try {
            this.em.lock(entity, this.getLockMode(lockMode));
            return entity;
        }
        catch (RuntimeException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public E refresh(E entity) {
        try {
            if (!this.em.contains(entity)) {
                Object pk = this.emf.getPersistenceUnitUtil().getIdentifier(entity);
                return (E)this.em.find(this.getClazz(), pk);
            }
            this.em.refresh(entity);
            return entity;
        }
        catch (RuntimeException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public E refresh(E entity, String lockMode) {
        try {
            if (!this.em.contains(entity)) {
                Object pk = this.emf.getPersistenceUnitUtil().getIdentifier(entity);
                return (E)this.em.find(this.getClazz(), pk, this.getLockMode(lockMode));
            }
            this.em.refresh(entity, this.getLockMode(lockMode));
            return entity;
        }
        catch (RuntimeException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public int sqlUpdate(String sql) {
        try {
            return this.em.createNativeQuery(sql).executeUpdate();
        }
        catch (RuntimeException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public int sqlUpdate(String sql, Object ... parameters) {
        try {
            int i = 0;
            Query query = this.em.createNativeQuery(sql);
            if (parameters != null && parameters.length > 0) {
                for (Object paramter : parameters) {
                    query.setParameter(++i, paramter);
                }
            }
            return query.executeUpdate();
        }
        catch (RuntimeException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public int sqlUpdate(String sql, Map<String, ?> parameters) {
        try {
            boolean i = false;
            Query query = this.em.createNativeQuery(sql);
            if (parameters != null && !parameters.isEmpty()) {
                for (Map.Entry<String, ?> entry : parameters.entrySet()) {
                    query.setParameter(entry.getKey(), entry.getValue());
                }
            }
            return query.executeUpdate();
        }
        catch (RuntimeException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public List<Integer> sqlUpdate(List<String> sqls) {
        try {
            ArrayList<Integer> res = new ArrayList<Integer>(sqls.size());
            for (String sql : sqls) {
                res.add(this.em.createNativeQuery(sql).executeUpdate());
            }
            return res;
        }
        catch (RuntimeException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public int bulkUpdate(String QL) {
        try {
            return this.em.createQuery(QL).executeUpdate();
        }
        catch (RuntimeException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public List<Integer> bulkUpdate(List<String> QLs) {
        try {
            ArrayList<Integer> result = new ArrayList<Integer>();
            for (String ql : QLs) {
                result.add(this.em.createQuery(ql).executeUpdate());
            }
            return result;
        }
        catch (RuntimeException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public int bulkUpdate(String QL, Object ... parameters) {
        try {
            Query query = this.em.createQuery(QL);
            int i = 0;
            if (parameters != null && parameters.length > 0) {
                for (Object paramter : parameters) {
                    query.setParameter(++i, paramter);
                }
            }
            return query.executeUpdate();
        }
        catch (RuntimeException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public int bulkUpdate(String QL, Map<String, ?> parameters) {
        try {
            Query query = this.em.createQuery(QL);
            boolean i = false;
            if (parameters != null && !parameters.isEmpty()) {
                for (Map.Entry<String, ?> entry : parameters.entrySet()) {
                    query.setParameter(entry.getKey(), entry.getValue());
                }
            }
            return query.executeUpdate();
        }
        catch (RuntimeException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public String $e() {
        return this.getEntityName();
    }

    @Override
    public String getEntityName() {
        return this.getClazz().getName();
    }

    @Override
    public String $a() {
        return this.getAliasName();
    }

    @Override
    public String $ea() {
        return this.getEntityName() + " AS " + this.getAliasName();
    }

    @Override
    public String getAliasName() {
        return AliasHelper.$a(this.getClazz());
    }

    protected List<E> findList(Query query) {
        try {
            EntityManagerFactoryUtils.applyTransactionTimeout((Query)query, (EntityManagerFactory)this.getEntityManagerFactory());
            return query.getResultList();
        }
        catch (RuntimeException e) {
            throw this.convertException(e);
        }
    }

    protected List<E> findList(Query query, Object ... parameters) {
        try {
            EntityManagerFactoryUtils.applyTransactionTimeout((Query)query, (EntityManagerFactory)this.getEntityManagerFactory());
            if (parameters != null && parameters.length > 0) {
                for (int i = 0; i < parameters.length; ++i) {
                    query.setParameter(i + 1, parameters[i]);
                }
            }
            return query.getResultList();
        }
        catch (RuntimeException e) {
            throw this.convertException(e);
        }
    }

    protected List<E> findList(Query query, Map<String, ?> parameters) {
        try {
            EntityManagerFactoryUtils.applyTransactionTimeout((Query)query, (EntityManagerFactory)this.getEntityManagerFactory());
            if (parameters != null && !parameters.isEmpty()) {
                for (Map.Entry<String, ?> entry : parameters.entrySet()) {
                    query.setParameter(entry.getKey(), entry.getValue());
                }
            }
            return query.getResultList();
        }
        catch (RuntimeException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public List<E> findByCriteria(String qlCriteria) {
        return this.findList(this.em.createQuery(JpqlHelper.get().select(this.$a()).from(this.$ea()).$(qlCriteria).ql()));
    }

    @Override
    public List<E> findByCriteria(String qlCriteria, Object ... parameters) {
        return this.findList(this.em.createQuery(JpqlHelper.get().select(this.$a()).from(this.$ea()).$(qlCriteria).ql()), parameters);
    }

    @Override
    public List<E> findByCriteria(String qlCriteria, Map<String, ?> parameters) {
        return this.findList(this.em.createQuery(JpqlHelper.get().select(this.$a()).from(this.$ea()).$(qlCriteria).ql()), parameters);
    }

    @Override
    public List<E> findByCriteria(String qlCriteria, int startPageNo, int pageSize, Object ... parameters) {
        if (startPageNo < 1 || pageSize < 1) {
            return parameters == null || parameters.length == 0 ? this.findByCriteria(qlCriteria) : this.findByCriteria(qlCriteria, parameters);
        }
        if (parameters == null || parameters.length == 0) {
            return this.findByCriteria(qlCriteria, startPageNo, pageSize);
        }
        return this.findList(this.em.createQuery(JpqlHelper.get().select(this.$a()).from(this.$ea()).$(qlCriteria).ql()).setFirstResult((startPageNo - 1) * pageSize).setMaxResults(pageSize), parameters);
    }

    @Override
    public List<E> findByCriteria(String qlCriteria, int startPageNo, int pageSize, Map<String, ?> parameters) {
        if (startPageNo < 1 || pageSize < 1) {
            return parameters == null || parameters.isEmpty() ? this.findByCriteria(qlCriteria) : this.findByCriteria(qlCriteria, parameters);
        }
        if (parameters == null || parameters.isEmpty()) {
            return this.findByCriteria(qlCriteria, startPageNo, pageSize);
        }
        return this.findList(this.em.createQuery(JpqlHelper.get().select(this.$a()).from(this.$ea()).$(qlCriteria).ql()).setFirstResult((startPageNo - 1) * pageSize).setMaxResults(pageSize), parameters);
    }

    @Override
    public List<E> findByCriteria(String qlCriteria, int startPageNo, int pageSize) {
        if (startPageNo < 1 || pageSize < 1) {
            return this.findByCriteria(qlCriteria);
        }
        return this.findList(this.em.createQuery(JpqlHelper.get().select(this.$a()).from(this.$ea()).$(qlCriteria).ql()).setFirstResult((startPageNo - 1) * pageSize).setMaxResults(pageSize));
    }

    @Override
    public List<E> findBySQLQuery(String sql) {
        return this.findList(this.em.createNativeQuery(sql, this.getClazz()));
    }

    @Override
    public List<E> findBySQLQuery(String sql, Object ... parameters) {
        return this.findList(this.em.createNativeQuery(sql, this.getClazz()), parameters);
    }

    @Override
    public List<E> findBySQLQuery(String sql, Map<String, ?> parameters) {
        return this.findList(this.em.createNativeQuery(sql, this.getClazz()), parameters);
    }

    @Override
    public <T> T findUniqueByQL(String QL) {
        try {
            Query query = this.em.createQuery(QL);
            EntityManagerFactoryUtils.applyTransactionTimeout((Query)query, (EntityManagerFactory)this.getEntityManagerFactory());
            return (T)query.getSingleResult();
        }
        catch (RuntimeException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public <T> T findUniqueByQL(String QL, Object ... parameters) {
        try {
            Query query = this.em.createQuery(QL);
            EntityManagerFactoryUtils.applyTransactionTimeout((Query)query, (EntityManagerFactory)this.getEntityManagerFactory());
            if (parameters != null && parameters.length > 0) {
                for (int i = 0; i < parameters.length; ++i) {
                    query.setParameter(i + 1, parameters[i]);
                }
            }
            return (T)query.getSingleResult();
        }
        catch (RuntimeException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public <T> T findUniqueByQL(String QL, Map<String, ?> parameters) {
        try {
            Query query = this.em.createQuery(QL);
            EntityManagerFactoryUtils.applyTransactionTimeout((Query)query, (EntityManagerFactory)this.getEntityManagerFactory());
            if (parameters != null && !parameters.isEmpty()) {
                for (Map.Entry<String, ?> entry : parameters.entrySet()) {
                    query.setParameter(entry.getKey(), entry.getValue());
                }
            }
            return (T)query.getSingleResult();
        }
        catch (RuntimeException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public <T> List<T> findListByQL(String QL) {
        try {
            Query query = this.em.createQuery(QL);
            EntityManagerFactoryUtils.applyTransactionTimeout((Query)query, (EntityManagerFactory)this.getEntityManagerFactory());
            return query.getResultList();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw this.convertException(e);
        }
    }

    @Override
    public <T> List<T> findListByQL(String QL, Object ... parameters) {
        try {
            Query query = this.em.createQuery(QL);
            EntityManagerFactoryUtils.applyTransactionTimeout((Query)query, (EntityManagerFactory)this.getEntityManagerFactory());
            if (parameters != null && parameters.length > 0) {
                for (int i = 0; i < parameters.length; ++i) {
                    query.setParameter(i + 1, parameters[i]);
                }
            }
            return query.getResultList();
        }
        catch (RuntimeException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public <T> List<T> findListByQL(String QL, Map<String, ?> parameters) {
        try {
            Query query = this.em.createQuery(QL);
            EntityManagerFactoryUtils.applyTransactionTimeout((Query)query, (EntityManagerFactory)this.getEntityManagerFactory());
            if (parameters != null && !parameters.isEmpty()) {
                for (Map.Entry<String, ?> entry : parameters.entrySet()) {
                    query.setParameter(entry.getKey(), entry.getValue());
                }
            }
            return query.getResultList();
        }
        catch (RuntimeException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public List<E> findByNamedQuery(String name) {
        return this.findList((Query)this.em.createNamedQuery(name, this.getClazz()));
    }

    @Override
    public List<E> findByNamedQuery(String name, Object ... parameters) {
        return this.findList((Query)this.em.createNamedQuery(name, this.getClazz()), parameters);
    }

    @Override
    public List<E> findByNamedQuery(String name, Map<String, ?> parameters) {
        return this.findList((Query)this.em.createNamedQuery(name, this.getClazz()), parameters);
    }

    @Override
    public <T> List<T> findListByNamedQuery(String name) {
        try {
            Query query = this.em.createNamedQuery(name);
            EntityManagerFactoryUtils.applyTransactionTimeout((Query)query, (EntityManagerFactory)this.getEntityManagerFactory());
            return query.getResultList();
        }
        catch (RuntimeException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public <T> List<T> findListByNamedQuery(String name, Object ... parameters) {
        try {
            Query query = this.em.createNamedQuery(name);
            EntityManagerFactoryUtils.applyTransactionTimeout((Query)query, (EntityManagerFactory)this.getEntityManagerFactory());
            if (parameters != null && parameters.length > 0) {
                for (int i = 0; i < parameters.length; ++i) {
                    query.setParameter(i + 1, parameters[i]);
                }
            }
            return query.getResultList();
        }
        catch (RuntimeException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public <T> List<T> findListByNamedQuery(String name, Map<String, ?> parameters) {
        try {
            Query query = this.em.createNamedQuery(name);
            EntityManagerFactoryUtils.applyTransactionTimeout((Query)query, (EntityManagerFactory)this.getEntityManagerFactory());
            if (parameters != null && !parameters.isEmpty()) {
                for (Map.Entry<String, ?> entry : parameters.entrySet()) {
                    query.setParameter(entry.getKey(), entry.getValue());
                }
            }
            return query.getResultList();
        }
        catch (RuntimeException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public E initLazyCollection(E entity, final String collectionFieldName) {
        final AtomicBoolean found = new AtomicBoolean(false);
        final String methodName = collectionFieldName.matches("^[a-z][A-Z]") ? collectionFieldName : (collectionFieldName.length() > 1 ? collectionFieldName.substring(0, 1).toUpperCase() + collectionFieldName.substring(1) : collectionFieldName.toUpperCase());
        final E obj = entity;
        final EntityManager fem = this.em;
        try {
            ReflectionUtils.doWithMethods((Class)this.getClazz(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                    try {
                        Method setter = obj.getClass().getMethod("s" + method.getName().substring(1), method.getReturnType());
                        PersistenceUnitUtil puu = fem.getEntityManagerFactory().getPersistenceUnitUtil();
                        if (!puu.isLoaded(obj, collectionFieldName)) {
                            Object reattach = fem.merge(obj);
                            Object fieldObj = method.invoke(reattach, new Object[0]);
                            ((Collection)fieldObj).size();
                            setter.invoke(obj, fieldObj);
                        }
                    }
                    catch (NoSuchMethodException ex) {
                        throw new PersistenceException("Setter " + AbstractSpringDao.this.getClazz().getSimpleName() + ".set" + methodName + "(...) not found.", (Throwable)ex);
                    }
                    catch (InvocationTargetException ex) {
                        throw new PersistenceException("Could not fetch Collection from " + AbstractSpringDao.this.getClazz().getSimpleName() + "." + method.getName(), (Throwable)ex);
                    }
                }
            }, (ReflectionUtils.MethodFilter)new ReflectionUtils.MethodFilter(){

                public boolean matches(Method method) {
                    if (found.get()) {
                        return false;
                    }
                    found.set(method.getName().equals("get" + methodName) && method.getParameterTypes().length == 0 && ClassUtils.isAssignable(Collection.class, method.getReturnType()));
                    return found.get();
                }
            });
            E e = obj;
            return e;
        }
        catch (IllegalArgumentException e) {
            throw this.convertException(e);
        }
        finally {
            EntityManagerFactoryUtils.closeEntityManager((EntityManager)fem);
        }
    }
}

