/*
 * Decompiled with CFR 0.152.
 */
package springdao.support;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JpqlHelper {
    private static final Logger logger = LogManager.getLogger(JpqlHelper.class);
    private final StringBuilder sb = new StringBuilder();

    public static JpqlHelper get() {
        return new JpqlHelper();
    }

    public static String $q(String s) {
        return "'" + s + "'";
    }

    public JpqlHelper $(String s) {
        this.sb.append(" ").append(s).append(" ");
        return this;
    }

    public JpqlHelper c$() {
        this.sb.append(" ,");
        return this;
    }

    public JpqlHelper c$(String s) {
        this.sb.append(",").append(s).append(" ");
        return this;
    }

    public JpqlHelper q$(String s) {
        this.sb.append(" '").append(s).append("' ");
        return this;
    }

    public JpqlHelper ps$(String s) {
        while (this.sb.length() > 0 && this.sb.charAt(this.sb.length() - 1) == ' ') {
            this.sb.delete(this.sb.length() - 1, this.sb.length());
        }
        this.sb.append("(").append(s).append(") ");
        return this;
    }

    public JpqlHelper lp$() {
        while (this.sb.length() > 0 && this.sb.charAt(this.sb.length() - 1) == ' ') {
            this.sb.delete(this.sb.length() - 1, this.sb.length());
        }
        this.sb.append("(");
        return this;
    }

    public JpqlHelper rp$() {
        while (this.sb.length() > 0 && this.sb.charAt(this.sb.length() - 1) == ' ') {
            this.sb.delete(this.sb.length() - 1, this.sb.length());
        }
        this.sb.append(")");
        return this;
    }

    public JpqlHelper sps$(String s) {
        this.sb.append(" (").append(s).append(") ");
        return this;
    }

    public JpqlHelper select() {
        return this.$("SELECT");
    }

    public JpqlHelper select(String fields) {
        return this.$("SELECT " + fields);
    }

    public JpqlHelper selectDistinct() {
        return this.$("SELECT DISTINCT");
    }

    public JpqlHelper selectDistinct(String fields) {
        return this.$("SELECT DISTINCT " + fields);
    }

    public JpqlHelper from() {
        return this.$("FROM");
    }

    public JpqlHelper from(String entity) {
        return this.$("FROM " + entity);
    }

    public JpqlHelper where() {
        return this.$("WHERE");
    }

    public JpqlHelper where(String qlCriteria) {
        return this.$("WHERE " + qlCriteria);
    }

    public JpqlHelper Case() {
        return this.$("CASE");
    }

    public JpqlHelper cCase() {
        return this.$(",CASE");
    }

    public JpqlHelper Case(String field) {
        return this.$("CASE " + field);
    }

    public JpqlHelper cCase(String field) {
        return this.$(",CASE " + field);
    }

    public JpqlHelper when() {
        return this.$("WHEN");
    }

    public JpqlHelper then() {
        return this.$("THEN");
    }

    public JpqlHelper whenThen(String condition, String result) {
        return this.$("WHEN " + condition + " THEN " + result);
    }

    public JpqlHelper Else(String result) {
        return this.$("ELSE " + result);
    }

    public JpqlHelper elseEnd(String result) {
        return this.$("ELSE " + result + " END");
    }

    public JpqlHelper end() {
        return this.$("END");
    }

    public JpqlHelper update() {
        return this.$("UPDATE");
    }

    public JpqlHelper update(String entity) {
        return this.$("UPDATE " + entity);
    }

    public JpqlHelper delete() {
        return this.$("DELETE FROM");
    }

    public JpqlHelper delete(String entity) {
        return this.$("DELETE FROM " + entity);
    }

    public JpqlHelper join() {
        return this.$("JOIN");
    }

    public JpqlHelper join(String other) {
        return this.$("JOIN " + other);
    }

    public JpqlHelper innerJoin() {
        return this.$("INNER JOIN");
    }

    public JpqlHelper innerJoin(String other) {
        return this.$("INNER JOIN " + other);
    }

    public JpqlHelper leftJoin() {
        return this.$("LEFT OUTER JOIN");
    }

    public JpqlHelper leftJoin(String other) {
        return this.$("LEFT OUTER JOIN " + other);
    }

    public JpqlHelper on() {
        return this.$("ON");
    }

    public JpqlHelper union() {
        return this.$("UNION");
    }

    public JpqlHelper intersect() {
        return this.$("INTERSECT");
    }

    public JpqlHelper except() {
        return this.$("EXCEPT");
    }

    public JpqlHelper groupBy() {
        return this.$("GROUP BY");
    }

    public JpqlHelper groupBy(String fields) {
        return this.$("GROUP BY " + fields);
    }

    public JpqlHelper having() {
        return this.$("HAVING");
    }

    public JpqlHelper having(String criteria) {
        return this.$("HAVING " + criteria);
    }

    public JpqlHelper fetch() {
        return this.$("FETCH");
    }

    public JpqlHelper fetch(String field) {
        return this.$("FETCH " + field);
    }

    public JpqlHelper distinct() {
        return this.$("DISTINCT");
    }

    public JpqlHelper distinct(String fields) {
        return this.$("DISTINCT " + fields);
    }

    public JpqlHelper isNull() {
        return this.$("IS NULL");
    }

    public JpqlHelper isNotNull() {
        return this.$("IS NOT NULL");
    }

    public JpqlHelper True() {
        return this.$("True");
    }

    public JpqlHelper False() {
        return this.$("False");
    }

    public JpqlHelper not() {
        return this.$("NOT");
    }

    public JpqlHelper and() {
        return this.$("AND");
    }

    public JpqlHelper or() {
        return this.$("OR");
    }

    public JpqlHelper between() {
        return this.$("BETWEEN");
    }

    public JpqlHelper between(String from, String to) {
        return this.$("BETWEEN " + from + " AND " + to);
    }

    public JpqlHelper like() {
        return this.$("LIKE");
    }

    public JpqlHelper like(String left, String right) {
        return this.$(left + " LIKE " + right);
    }

    public JpqlHelper in() {
        return this.$("IN");
    }

    public JpqlHelper in(String fields) {
        return this.$("IN (" + fields + ")");
    }

    public JpqlHelper as(String field) {
        return this.$("AS " + field);
    }

    public JpqlHelper isEmpty() {
        return this.$("IS EMPTY");
    }

    public JpqlHelper isNotEmpty() {
        return this.$("IS NOT EMPTY");
    }

    public JpqlHelper memberOf() {
        return this.$("MEMBER OF");
    }

    public JpqlHelper memberOf(String left, String right) {
        return this.$(left + " MEMBER OF " + right);
    }

    public JpqlHelper abs() {
        return this.$("ABS");
    }

    public JpqlHelper cAbs() {
        return this.$(",ABS");
    }

    public JpqlHelper abs(String field) {
        return this.$("ABS(" + field + ")");
    }

    public JpqlHelper cAbs(String field) {
        return this.$(",ABS(" + field + ")");
    }

    public JpqlHelper avg() {
        return this.$("AVG");
    }

    public JpqlHelper cAvg() {
        return this.$(",AVG");
    }

    public JpqlHelper avg(String field) {
        return this.$("AVG(" + field + ")");
    }

    public JpqlHelper cAvg(String field) {
        return this.$(",AVG(" + field + ")");
    }

    public JpqlHelper sqrt() {
        return this.$("SQRT");
    }

    public JpqlHelper cSqrt() {
        return this.$(",SQRT");
    }

    public JpqlHelper sqrt(String field) {
        return this.$("SQRT(" + field + ")");
    }

    public JpqlHelper cSqrt(String field) {
        return this.$(",SQRT(" + field + ")");
    }

    public JpqlHelper coalesce(String field, String defaultValue) {
        return this.$("COALESCE(" + field + "," + defaultValue + ")");
    }

    public JpqlHelper cCoalesce(String field, String defaultValue) {
        return this.$(",COALESCE(" + field + "," + defaultValue + ")");
    }

    public JpqlHelper nullif(String field, String defaultValue) {
        return this.$("NULLIF(" + field + "," + defaultValue + ")");
    }

    public JpqlHelper cNullif(String field, String defaultValue) {
        return this.$(",NULLIF(" + field + "," + defaultValue + ")");
    }

    public JpqlHelper max() {
        return this.$("MAX");
    }

    public JpqlHelper cMax() {
        return this.$(",MAX");
    }

    public JpqlHelper max(String field) {
        return this.$("MAX(" + field + ")");
    }

    public JpqlHelper cMax(String field) {
        return this.$(",MAX(" + field + ")");
    }

    public JpqlHelper min() {
        return this.$("MIN");
    }

    public JpqlHelper cMin() {
        return this.$(",MIN");
    }

    public JpqlHelper min(String field) {
        return this.$("MIN(" + field + ")");
    }

    public JpqlHelper cMin(String field) {
        return this.$(",MIN(" + field + ")");
    }

    public JpqlHelper sum() {
        return this.$("SUM");
    }

    public JpqlHelper cSum() {
        return this.$(",SUM");
    }

    public JpqlHelper sum(String field) {
        return this.$("SUM(" + field + ")");
    }

    public JpqlHelper cSum(String field) {
        return this.$(",SUM(" + field + ")");
    }

    public JpqlHelper count() {
        this.sb.append(" COUNT");
        return this;
    }

    public JpqlHelper cCount() {
        this.sb.append(" ,COUNT");
        return this;
    }

    public JpqlHelper count(String field) {
        return this.$("COUNT(" + field + ")");
    }

    public JpqlHelper cCount(String field) {
        return this.$(",COUNT(" + field + ")");
    }

    public JpqlHelper countDistinct(String field) {
        return this.$("COUNT(DISTINCT " + field + ")");
    }

    public JpqlHelper cCountDistinct(String field) {
        return this.$(",COUNT(DISTINCT " + field + ")");
    }

    public JpqlHelper orderBy() {
        return this.$("ORDER BY");
    }

    public JpqlHelper nullsFirst() {
        return this.$("NULLS FIRST");
    }

    public JpqlHelper orderBy(String fields) {
        return this.$("ORDER BY " + fields);
    }

    public JpqlHelper asc() {
        return this.$("ASC");
    }

    public JpqlHelper desc() {
        return this.$("DESC");
    }

    public JpqlHelper mod(String number, String divisor) {
        return this.$("MOD(" + number + ", " + divisor + ")");
    }

    public JpqlHelper cMod(String number, String divisor) {
        return this.$(",MOD(" + number + ", " + divisor + ")");
    }

    public JpqlHelper upper() {
        return this.$("UPPER");
    }

    public JpqlHelper cUpper() {
        return this.$(",UPPER");
    }

    public JpqlHelper upper(String field) {
        return this.$("UPPER(" + field + ")");
    }

    public JpqlHelper cUpper(String field) {
        return this.$(",UPPER(" + field + ")");
    }

    public JpqlHelper lower() {
        return this.$("LOWER");
    }

    public JpqlHelper cLower() {
        return this.$(",LOWER");
    }

    public JpqlHelper lower(String field) {
        return this.$("LOWER(" + field + ")");
    }

    public JpqlHelper cLower(String field) {
        return this.$(",LOWER(" + field + ")");
    }

    public JpqlHelper trim() {
        return this.$("TRIM");
    }

    public JpqlHelper cTrim() {
        return this.$(",TRIM");
    }

    public JpqlHelper trim(String field) {
        return this.$("TRIM(" + field + ")");
    }

    public JpqlHelper cTrim(String field) {
        return this.$(",TRIM(" + field + ")");
    }

    public JpqlHelper concat(String first, String second) {
        return this.$("CONCAT(" + first + ", " + second + ")");
    }

    public JpqlHelper cConcat(String first, String second) {
        return this.$(",CONCAT(" + first + ", " + second + ")");
    }

    public JpqlHelper substring(String field, int start, int end) {
        return this.$("SUBSTRING(" + field + ", " + start + ", " + end + ")");
    }

    public JpqlHelper cSubstring(String field, int start, int end) {
        return this.$(",SUBSTRING(" + field + ", " + start + ", " + end + ")");
    }

    public JpqlHelper locate(String substr, String field) {
        return this.$("LOCATE(" + substr + ", " + field + ")");
    }

    public JpqlHelper cLocate(String substr, String field) {
        return this.$(",LOCATE(" + substr + ", " + field + ")");
    }

    public JpqlHelper length() {
        return this.$("LENGTH");
    }

    public JpqlHelper cLength() {
        return this.$(",LENGTH");
    }

    public JpqlHelper length(String field) {
        return this.$("LENGTH(" + field + ")");
    }

    public JpqlHelper cLength(String field) {
        return this.$(",LENGTH(" + field + ")");
    }

    public JpqlHelper currTime() {
        return this.$("CURRENT_TIME");
    }

    public JpqlHelper cCurrTime() {
        return this.$(",CURRENT_TIME");
    }

    public JpqlHelper currDate() {
        return this.$("CURRENT_DATE");
    }

    public JpqlHelper cCurrDate() {
        return this.$(",CURRENT_DATE");
    }

    public JpqlHelper currTimeStamp() {
        return this.$("CURRENT_TIMESTAMP");
    }

    public JpqlHelper cCurrTimeStamp() {
        return this.$(",CURRENT_TIMESTAMP");
    }

    public JpqlHelper New() {
        return this.$("NEW");
    }

    public JpqlHelper New(String entityName, String ... fields) {
        this.sb.append(" NEW ").append(entityName).append("(");
        if (fields != null && fields.length > 0) {
            int i = 0;
            for (String field : fields) {
                this.sb.append(i++ == 0 ? "" : ", ").append(field);
            }
            this.sb.append(") ");
        }
        return this;
    }

    public JpqlHelper exists() {
        return this.$("EXISTS");
    }

    public JpqlHelper notExists() {
        return this.$("NOT EXISTS");
    }

    public JpqlHelper all() {
        return this.$("ALL");
    }

    public JpqlHelper all(String subquery) {
        return this.$("ALL(" + subquery + ")");
    }

    public JpqlHelper any() {
        return this.$("ANY");
    }

    public JpqlHelper any(String subquery) {
        return this.$("ANY(" + subquery + ")");
    }

    public JpqlHelper some() {
        return this.$("SOME");
    }

    public JpqlHelper some(String subquery) {
        return this.$("SOME(" + subquery + ")");
    }

    public JpqlHelper set() {
        return this.$("SET");
    }

    public JpqlHelper set(String left, String right) {
        return this.$("SET " + left + " = " + right);
    }

    public JpqlHelper eq() {
        return this.$("=");
    }

    public JpqlHelper eq(String right) {
        return this.$(" = " + right);
    }

    public JpqlHelper eq(String left, String right) {
        return this.$(left + " = " + right);
    }

    public String format(Object ... args) {
        return String.format(this.toString(), args);
    }

    public JpqlHelper cast(String field, String typeValue) {
        return this.$("CAST(" + field + ", " + typeValue + ")");
    }

    public JpqlHelper extract(String dt, String field) {
        return this.$("EXTRACT(" + dt + ", " + field + ")");
    }

    public JpqlHelper cExtract(String dt, String field) {
        return this.$(",EXTRACT(" + dt + ", " + field + ")");
    }

    public JpqlHelper function(String name, String ... values) {
        this.sb.append(" ").append("FUNCTION('").append(name).append("'");
        if (values != null && values.length > 0) {
            for (String value : values) {
                this.sb.append(", ").append(value);
            }
        }
        this.sb.append(")");
        return this;
    }

    public JpqlHelper operator(String name, String ... values) {
        this.sb.append(" ").append("OPERATOR('").append(name).append("'");
        if (values != null && values.length > 0) {
            for (String value : values) {
                this.sb.append(", ").append(value);
            }
        }
        this.sb.append(")");
        return this;
    }

    public JpqlHelper treat(String entity) {
        return this.$("TREAT(" + entity + ")");
    }

    public JpqlHelper regexp() {
        return this.$("REGEXP");
    }

    public JpqlHelper regexp(String field, String regexpr) {
        return this.$(field + " REGEXP " + regexpr);
    }

    public JpqlHelper column(String field, String entityOrAlias) {
        return this.$("COLUMN('" + field + "', " + entityOrAlias + ")");
    }

    public JpqlHelper table(String name) {
        return this.$("TABLE('" + name + "')");
    }

    public String toString() {
        int pos = 0;
        while ((pos = this.sb.indexOf("  ", pos)) != -1) {
            this.sb.delete(pos, pos + 1);
        }
        logger.debug("JPQL:{}", (Object)this.sb.toString());
        while (this.sb.length() > 0 && this.sb.charAt(0) == ' ') {
            this.sb.delete(0, 1);
        }
        while (this.sb.length() > 0 && this.sb.charAt(this.sb.length() - 1) == ' ') {
            this.sb.delete(this.sb.length() - 1, this.sb.length());
        }
        return this.sb.toString();
    }

    public String ql() {
        return this.toString();
    }
}

